/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.issues;

import com.google.inject.Inject;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesIssueTracking
implements IssueTracking {
    private final EnvironmentVariables environmentVariables;

    @Inject
    public SystemPropertiesIssueTracking(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getIssueTrackerUrl() {
        if (this.jiraUrlDefined()) {
            return this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName()) + "/browse/" + "{0}";
        }
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.ISSUE_TRACKER_URL.getPropertyName());
    }

    public String getShortenedIssueTrackerUrl() {
        if (this.jiraUrlDefined()) {
            return this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName()) + "/browse/" + this.getJiraProjectSuffix() + "{0}";
        }
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.ISSUE_TRACKER_URL.getPropertyName());
    }

    private String getJiraProjectSuffix() {
        if (this.jiraProjectDefined()) {
            return this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_PROJECT.getPropertyName()) + "-";
        }
        return "";
    }

    private boolean jiraUrlDefined() {
        return !StringUtils.isEmpty((CharSequence)this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName()));
    }

    private boolean jiraProjectDefined() {
        return !StringUtils.isEmpty((CharSequence)this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_PROJECT.getPropertyName()));
    }
}

