/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.DataDrivenStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestResultTally;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepEventBus {
    private static ThreadLocal<StepEventBus> stepEventBusThreadLocal = new ThreadLocal();
    private static final String CORE_THUCYDIDES_PACKAGE = "net.thucydides.core";
    private static final Logger LOGGER = LoggerFactory.getLogger(StepEventBus.class);
    private List<StepListener> registeredListeners = new ArrayList<StepListener>();
    private BaseStepListener baseStepListener;
    private TestResultTally resultTally;
    private Stack<String> stepStack = new Stack();
    private Stack<Boolean> webdriverSuspensions = new Stack();
    private Set<StepListener> customListeners;
    private boolean stepFailed;
    private boolean pendingTest;
    private boolean uniqueSession;
    private Class<?> classUnderTest;
    private Story storyUnderTest;
    private final ScreenshotProcessor screenshotProcessor;

    public static synchronized StepEventBus getEventBus() {
        if (stepEventBusThreadLocal.get() == null) {
            stepEventBusThreadLocal.set((StepEventBus)Injectors.getInjector().getInstance(StepEventBus.class));
        }
        return stepEventBusThreadLocal.get();
    }

    @Inject
    public StepEventBus(ScreenshotProcessor screenshotProcessor) {
        this.screenshotProcessor = screenshotProcessor;
    }

    public StepEventBus registerListener(StepListener listener) {
        if (!this.registeredListeners.contains(listener)) {
            this.registeredListeners.add(listener);
            if (BaseStepListener.class.isAssignableFrom(listener.getClass())) {
                this.baseStepListener = (BaseStepListener)listener;
                this.baseStepListener.setEventBus(this);
            }
        }
        return this;
    }

    private BaseStepListener getBaseStepListener() {
        Preconditions.checkNotNull((Object)this.baseStepListener, (Object)"No BaseStepListener has been registered");
        return this.baseStepListener;
    }

    public void testStarted(String testName) {
        this.clear();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testStarted(testName);
        }
    }

    public boolean isUniqueSession() {
        return this.uniqueSession;
    }

    public void setUniqueSession(boolean uniqueSession) {
        this.uniqueSession = uniqueSession;
    }

    public void testStarted(String newTestName, Story story) {
        this.startSuiteWithStoryForFirstTest(story);
        this.testStarted(newTestName);
    }

    public void testStarted(String newTestName, Class<?> testClass) {
        if (newTestName != null) {
            this.testStarted(newTestName);
        }
    }

    private void startSuiteWithStoryForFirstTest(Story story) {
        if (this.storyUnderTest == null || this.storyUnderTest != story) {
            this.testSuiteStarted(story);
        }
    }

    protected List<StepListener> getAllListeners() {
        ArrayList allListeners = Lists.newArrayList(this.registeredListeners);
        allListeners.addAll(this.getCustomListeners());
        return ImmutableList.copyOf((Collection)allListeners);
    }

    private Set<StepListener> getCustomListeners() {
        if (this.customListeners == null) {
            this.customListeners = Collections.synchronizedSet(new HashSet());
            Iterator listenerImplementations = Service.providers(StepListener.class);
            while (listenerImplementations.hasNext()) {
                StepListener listener = (StepListener)listenerImplementations.next();
                if (this.isACore(listener)) continue;
                LOGGER.info("Registering custom listener " + listener);
                this.customListeners.add(listener);
            }
        }
        return this.customListeners;
    }

    private boolean isACore(StepListener listener) {
        return listener.getClass().getPackage().getName().startsWith(CORE_THUCYDIDES_PACKAGE);
    }

    public void testSuiteStarted(Class<?> testClass) {
        LOGGER.debug("Test suite started for {}", testClass);
        this.clear();
        this.updateClassUnderTest(testClass);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(testClass);
        }
    }

    private void updateClassUnderTest(Class<?> testClass) {
        this.classUnderTest = testClass;
    }

    private void updateStoryUnderTest(Story story) {
        this.storyUnderTest = story;
    }

    public void testSuiteStarted(Story story) {
        LOGGER.debug("Test suite started for story {}", (Object)story);
        this.updateStoryUnderTest(story);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(story);
        }
    }

    public void clear() {
        this.stepStack.clear();
        this.clearStepFailures();
        this.currentTestIsNotPending();
        this.resultTally = null;
        this.classUnderTest = null;
        this.webdriverSuspensions.clear();
    }

    private void currentTestIsNotPending() {
        this.pendingTest = false;
    }

    private TestResultTally getResultTally() {
        if (this.resultTally == null) {
            this.resultTally = TestResultTally.forTestClass(this.classUnderTest);
        }
        return this.resultTally;
    }

    public void testFinished() {
        this.screenshotProcessor.waitUntilDone();
        TestOutcome outcome = this.getBaseStepListener().getCurrentTestOutcome();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFinished(outcome);
        }
        this.clear();
    }

    public void testFinished(TestOutcome result) {
        this.screenshotProcessor.waitUntilDone();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFinished(result);
        }
        this.clear();
    }

    private void pushStep(String stepName) {
        this.stepStack.push(stepName);
    }

    private void popStep() {
        this.stepStack.pop();
    }

    public void clearStepFailures() {
        this.stepFailed = false;
    }

    public boolean aStepInTheCurrentTestHasFailed() {
        return this.stepFailed;
    }

    public boolean isCurrentTestDataDriven() {
        return DataDrivenStep.inProgress();
    }

    public void stepStarted(ExecutedStepDescription stepDescription) {
        this.pushStep(stepDescription.getName());
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepStarted(stepDescription);
        }
    }

    public void skippedStepStarted(ExecutedStepDescription executedStepDescription) {
        this.pushStep(executedStepDescription.getName());
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.skippedStepStarted(executedStepDescription);
        }
    }

    public void stepFinished() {
        this.stepDone();
        this.getResultTally().logExecutedTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFinished();
        }
    }

    private void stepDone() {
        if (!this.stepStack.empty()) {
            this.popStep();
        }
    }

    public void stepFailed(StepFailure failure) {
        this.stepDone();
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void lastStepFailed(StepFailure failure) {
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void stepIgnored() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepIgnored();
        }
    }

    public void stepPending() {
        this.stepPending(null);
    }

    public void stepPending(String message) {
        this.testPending();
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            if (message != null) {
                stepListener.stepPending(message);
                continue;
            }
            stepListener.stepPending();
        }
    }

    public void dropListener(StepListener stepListener) {
        this.registeredListeners.remove(stepListener);
    }

    public void dropAllListeners() {
        this.registeredListeners.clear();
    }

    public boolean webdriverCallsAreSuspended() {
        return this.aStepInTheCurrentTestHasFailed() || !this.webdriverSuspensions.isEmpty();
    }

    public void reenableWebdriverCalls() {
        this.webdriverSuspensions.pop();
    }

    public void temporarilySuspendWebdriverCalls() {
        this.webdriverSuspensions.push(true);
    }

    public void testFailed(Throwable cause) {
        TestOutcome outcome = this.getBaseStepListener().getCurrentTestOutcome();
        for (StepListener stepListener : this.getAllListeners()) {
            try {
                stepListener.testFailed(outcome, cause);
            }
            catch (AbstractMethodError ame) {
                LOGGER.warn("Caught abstract method error - this seems to be mostly harmless.");
            }
        }
    }

    public void testPending() {
        this.pendingTest = true;
    }

    public boolean currentTestIsPending() {
        return this.pendingTest;
    }

    public void testIgnored() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testIgnored();
        }
    }

    public boolean areStepsRunning() {
        return !this.stepStack.isEmpty();
    }

    public void notifyScreenChange() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.notifyScreenChange();
        }
    }

    public void testSuiteFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteFinished();
        }
        if (!this.isUniqueSession()) {
            ThucydidesWebDriverSupport.closeAllDrivers();
        }
        this.storyUnderTest = null;
    }

    public void updateCurrentStepTitle(String stepTitle) {
        this.getBaseStepListener().updateCurrentStepTitle(stepTitle);
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.getBaseStepListener().addIssuesToCurrentStory(issues);
    }

    public void addIssuesToCurrentTest(List<String> issues) {
        this.getBaseStepListener().getCurrentTestOutcome().addIssues(issues);
    }

    public void addTagsToCurrentTest(List<TestTag> tags) {
        this.getBaseStepListener().getCurrentTestOutcome().addTags(tags);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.getBaseStepListener().addTagsToCurrentStory(tags);
    }

    public void useExamplesFrom(DataTable table) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.useExamplesFrom(table);
        }
    }

    public void exampleStarted(Map<String, String> data) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.exampleStarted(data);
        }
    }

    public void exampleFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.exampleFinished();
        }
    }

    public void takeScreenshot() {
        this.getBaseStepListener().takeScreenshot();
    }
}

