/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.TestResult;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.webdriver.WebdriverAssertionError;

public class FailureAnalysis {
    public TestResult resultFor(Throwable testFailureCause) {
        if (this.isFailureError(testFailureCause)) {
            return TestResult.FAILURE;
        }
        if (this.failingStepException(testFailureCause)) {
            return TestResult.FAILURE;
        }
        return TestResult.ERROR;
    }

    private boolean failingStepException(Throwable testFailureCause) {
        return StepFailureException.class.isAssignableFrom(testFailureCause.getClass()) && testFailureCause.getCause() != null && this.isFailureError(testFailureCause.getCause());
    }

    private boolean isFailureError(Throwable testFailureCause) {
        Class<?> failureCauseClass = testFailureCause.getClass();
        if (WebdriverAssertionError.class.isAssignableFrom(failureCauseClass)) {
            return testFailureCause.getCause() == null || AssertionError.class.isAssignableFrom(testFailureCause.getCause().getClass());
        }
        return AssertionError.class.isAssignableFrom(failureCauseClass);
    }
}

