/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thucydides.core.IgnoredStepException;
import net.thucydides.core.PendingStepException;
import net.thucydides.core.Thucydides;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.ScreenshotPermission;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.screenshots.Photographer;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.screenshots.ScreenshotBlurCheck;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStepListener
implements StepListener,
StepPublisher {
    private final List<TestOutcome> testOutcomes;
    private final Stack<TestStep> currentStepStack;
    private final Stack<TestStep> currentGroupStack;
    private StepEventBus eventBus;
    private final SystemClock clock;
    private ScreenshotPermission screenshots;
    private Class<?> testSuite;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStepListener.class);
    private WebDriver driver;
    private File outputDirectory;
    private WebdriverProxyFactory proxyFactory = WebdriverProxyFactory.getFactory();
    private Story testedStory;
    private Configuration configuration;
    ScreenshotProcessor screenshotProcessor;
    private boolean inFluentStepSequence;
    private List<String> storywideIssues;
    private List<TestTag> storywideTags;
    int currentExample = 0;

    public void setEventBus(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public StepEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = StepEventBus.getEventBus();
        }
        return this.eventBus;
    }

    public BaseStepListener(File outputDirectory) {
        this.testOutcomes = new ArrayList<TestOutcome>();
        this.currentStepStack = new Stack();
        this.currentGroupStack = new Stack();
        this.outputDirectory = outputDirectory;
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
        this.configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        this.screenshotProcessor = (ScreenshotProcessor)Injectors.getInjector().getInstance(ScreenshotProcessor.class);
        this.inFluentStepSequence = false;
        this.storywideIssues = Lists.newArrayList();
        this.storywideTags = Lists.newArrayList();
    }

    protected ScreenshotPermission screenshots() {
        if (this.screenshots == null) {
            this.screenshots = new ScreenshotPermission(this.configuration);
        }
        return this.screenshots;
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory, Configuration configuration) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
        this.configuration = configuration;
    }

    public BaseStepListener(File outputDirectory, Configuration configuration) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(null);
        this.configuration = configuration;
    }

    public BaseStepListener(File outputDirectory, Pages pages) {
        this(outputDirectory);
        if (pages != null) {
            this.setDriverUsingPagesDriverIfDefined(pages);
        } else {
            this.createNewDriver();
        }
    }

    private void createNewDriver() {
        this.setDriver(this.getProxyFactory().proxyDriver());
    }

    private void setDriverUsingPagesDriverIfDefined(Pages pages) {
        if (pages.getDriver() != null) {
            this.setDriver(pages.getDriver());
        } else {
            this.createNewDriver();
            pages.setDriver(this.getDriver());
        }
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected TestOutcome getCurrentTestOutcome() {
        Preconditions.checkState((!this.testOutcomes.isEmpty() ? 1 : 0) != 0);
        return this.testOutcomes.get(this.testOutcomes.size() - 1);
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    @Override
    public void testSuiteStarted(Class<?> startedTestSuite) {
        this.testSuite = startedTestSuite;
        this.testedStory = Stories.findStoryFrom(startedTestSuite);
        this.clearStorywideTagsAndIssues();
    }

    private void clearStorywideTagsAndIssues() {
        this.storywideIssues.clear();
        this.storywideTags.clear();
    }

    @Override
    public void testSuiteStarted(Story story) {
        this.testSuite = null;
        this.testedStory = story;
        this.clearStorywideTagsAndIssues();
    }

    public boolean testSuiteRunning() {
        return this.testedStory != null;
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.storywideIssues.addAll(issues);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.storywideTags.addAll(tags);
    }

    @Override
    public void testSuiteFinished() {
        this.screenshotProcessor.waitUntilDone();
        this.clearStorywideTagsAndIssues();
    }

    @Override
    public void testStarted(String testMethod) {
        this.testOutcomes.add(TestOutcome.forTestInStory(testMethod, this.testSuite, this.testedStory));
        this.updateSessionIdIfKnown();
        this.setAnnotatedResult(testMethod);
    }

    private void updateSessionIdIfKnown() {
        String sessionId = Thucydides.getCurrentSessionID();
        if (sessionId != null) {
            this.getCurrentTestOutcome().setSessionId(sessionId);
        }
    }

    public void updateCurrentStepTitle(String updatedStepTitle) {
        this.getCurrentStep().setDescription(updatedStepTitle);
    }

    private void setAnnotatedResult(String testMethod) {
        if (TestAnnotations.forClass(this.testSuite).isIgnored(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
        if (TestAnnotations.forClass(this.testSuite).isPending(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        }
    }

    @Override
    public void testFinished(TestOutcome outcome) {
        this.recordTestDuration();
        this.getCurrentTestOutcome().addIssues(this.storywideIssues);
        this.getCurrentTestOutcome().addTags(this.storywideTags);
        this.currentStepStack.clear();
    }

    private void recordTestDuration() {
        if (!this.testOutcomes.isEmpty()) {
            this.getCurrentTestOutcome().recordDuration();
        }
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
        this.takeInitialScreenshot();
        this.updateSessionIdIfKnown();
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
    }

    private void recordStep(ExecutedStepDescription description) {
        String stepName = AnnotatedStepDescription.from(description).getName();
        this.updateFluentStepStatus(description, stepName);
        if (this.justStartedAFluentSequenceFor(description) || this.notInAFluentSequence()) {
            TestStep step = new TestStep(stepName);
            this.startNewGroupIfNested();
            this.setDefaultResultFromAnnotations(step, description);
            this.currentStepStack.push(step);
            this.recordStepToCurrentTestOutcome(step);
        }
        this.inFluentStepSequence = AnnotatedStepDescription.from(description).isFluent();
    }

    private void recordStepToCurrentTestOutcome(TestStep step) {
        this.getCurrentTestOutcome().recordStep(step);
    }

    private void updateFluentStepStatus(ExecutedStepDescription description, String stepName) {
        if (this.currentlyInAFluentSequenceFor(description) || this.justFinishedAFluentSequenceFor(description)) {
            this.addToFluentStepName(stepName);
        }
    }

    private void addToFluentStepName(String stepName) {
        String updatedStepName = this.getCurrentStep().getDescription() + " " + StringUtils.uncapitalize((String)stepName);
        this.getCurrentStep().setDescription(updatedStepName);
    }

    private boolean notInAFluentSequence() {
        return !this.inFluentStepSequence;
    }

    private boolean justFinishedAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = AnnotatedStepDescription.from(description).isFluent();
        return this.inFluentStepSequence && !thisStepIsFluent;
    }

    private boolean justStartedAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = AnnotatedStepDescription.from(description).isFluent();
        return !this.inFluentStepSequence && thisStepIsFluent;
    }

    private boolean currentlyInAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = AnnotatedStepDescription.from(description).isFluent();
        return this.inFluentStepSequence && thisStepIsFluent;
    }

    private void setDefaultResultFromAnnotations(TestStep step, ExecutedStepDescription description) {
        if (TestAnnotations.isPending(description.getTestMethod())) {
            step.setResult(TestResult.PENDING);
        }
        if (TestAnnotations.isIgnored(description.getTestMethod())) {
            step.setResult(TestResult.SKIPPED);
        }
    }

    private void startNewGroupIfNested() {
        if (this.thereAreUnfinishedSteps() && this.getCurrentStep() != this.getCurrentGroup()) {
            this.startNewGroup();
        }
    }

    private void startNewGroup() {
        this.getCurrentTestOutcome().startGroup();
        this.currentGroupStack.push(this.getCurrentStep());
    }

    private TestStep getCurrentStep() {
        return this.currentStepStack.peek();
    }

    private Optional<TestStep> getPreviousStep() {
        if (this.currentStepStack.size() > 1) {
            return Optional.of(this.currentStepStack.get(this.currentStepStack.size() - 2));
        }
        return Optional.absent();
    }

    private TestStep getCurrentGroup() {
        if (this.currentGroupStack.isEmpty()) {
            return null;
        }
        return this.currentGroupStack.peek();
    }

    private boolean thereAreUnfinishedSteps() {
        return !this.currentStepStack.isEmpty();
    }

    @Override
    public void stepFinished() {
        this.updateSessionIdIfKnown();
        this.takeEndOfStepScreenshotFor(TestResult.SUCCESS);
        this.currentStepDone();
        this.markCurrentStepAs(TestResult.SUCCESS);
        this.pauseIfRequired();
    }

    private void updateExampleTableIfNecessary(TestResult result) {
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateCurrentRowResult(result);
        }
    }

    private void finishGroup() {
        this.currentGroupStack.pop();
        this.getCurrentTestOutcome().endGroup();
    }

    private void pauseIfRequired() {
        int delay = this.configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor(delay);
        }
    }

    private void markCurrentStepAs(TestResult result) {
        this.getCurrentTestOutcome().getCurrentStep().setResult(result);
        this.updateExampleTableIfNecessary(result);
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().setTestFailureCause(failure.getException());
        this.markCurrentStepAs(TestResult.FAILURE);
        this.recordFailureDetailsInFailingTestStep(failure);
        this.currentStepDone();
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().lastStepFailedWith(failure);
    }

    private void recordFailureDetailsInFailingTestStep(StepFailure failure) {
        if (this.currentStepExists()) {
            this.getCurrentStep().failedWith(new StepFailureException(failure.getMessage(), failure.getException()));
        }
    }

    @Override
    public void stepIgnored() {
        if (this.aStepHasFailed()) {
            this.markCurrentStepAs(TestResult.SKIPPED);
            this.currentStepDone();
        } else {
            this.markCurrentStepAs(TestResult.IGNORED);
            this.currentStepDone();
        }
    }

    @Override
    public void stepIgnored(String message) {
        this.getCurrentStep().testAborted(new IgnoredStepException(message));
        this.stepIgnored();
    }

    @Override
    public void stepPending() {
        this.markCurrentStepAs(TestResult.PENDING);
        this.currentStepDone();
    }

    @Override
    public void stepPending(String message) {
        this.getCurrentStep().testAborted(new PendingStepException(message));
        this.stepPending();
    }

    private void currentStepDone() {
        if (!this.inFluentStepSequence && this.currentStepExists()) {
            TestStep finishedStep = this.currentStepStack.pop();
            finishedStep.recordDuration();
            if (finishedStep == this.getCurrentGroup()) {
                this.finishGroup();
            }
        }
    }

    private boolean currentStepExists() {
        return !this.currentStepStack.isEmpty();
    }

    private void takeEndOfStepScreenshotFor(TestResult result) {
        if (this.shouldTakeEndOfStepScreenshotFor(result)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    private void take(ScreenshotType screenshotType) {
        if (this.currentStepExists() && this.browserIsOpen()) {
            try {
                String stepDescription = this.getCurrentTestOutcome().getCurrentStep().getDescription();
                String testName = this.getCurrentTestOutcome().getTitle();
                Optional<ScreenshotAndHtmlSource> screenshotAndHtmlSource = this.grabScreenshotFor(testName + ":" + stepDescription);
                if (screenshotAndHtmlSource.isPresent()) {
                    this.takeScreenshotIfRequired(screenshotType, (ScreenshotAndHtmlSource)screenshotAndHtmlSource.get());
                }
                this.removeDuplicatedInitalScreenshotsIfPresent();
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private void removeDuplicatedInitalScreenshotsIfPresent() {
        if (this.currentStepHasMoreThanOneScreenshot() && this.getPreviousStep().isPresent()) {
            ScreenshotAndHtmlSource lastScreenshotOfPreviousStep = this.lastScreenshotOf((TestStep)this.getPreviousStep().get());
            ScreenshotAndHtmlSource firstScreenshotOfThisStep = this.getCurrentStep().getFirstScreenshot();
            if (this.haveIdenticalScreenshots(firstScreenshotOfThisStep, lastScreenshotOfPreviousStep)) {
                this.removeFirstScreenshotOfCurrentStep();
            }
        }
    }

    private void removeFirstScreenshotOfCurrentStep() {
        this.getCurrentStep().removeScreenshot(0);
    }

    private boolean currentStepHasMoreThanOneScreenshot() {
        return this.getCurrentStep().getScreenshotCount() > 1;
    }

    private ScreenshotAndHtmlSource lastScreenshotOf(TestStep testStep) {
        if (!testStep.getScreenshots().isEmpty()) {
            return testStep.getScreenshots().get(testStep.getScreenshots().size() - 1);
        }
        return null;
    }

    private void takeScreenshotIfRequired(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.shouldTakeScreenshot(screenshotType, screenshotAndHtmlSource) && this.screenshotWasTaken(screenshotAndHtmlSource)) {
            this.getCurrentStep().addScreenshot(screenshotAndHtmlSource);
        }
    }

    private boolean screenshotWasTaken(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.getScreenshotFile() != null;
    }

    private boolean shouldTakeScreenshot(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotType == ScreenshotType.MANDATORY_SCREENSHOT || this.getCurrentStep().getScreenshots().isEmpty() || this.shouldTakeOptionalScreenshot(screenshotAndHtmlSource);
    }

    private boolean shouldTakeOptionalScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.wasTaken() && !this.sameAsPreviousScreenshot(screenshotAndHtmlSource);
    }

    private boolean sameAsPreviousScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        try {
            Optional<Screenshot> screenshot = this.latestScreenshot();
            if (screenshot.isPresent()) {
                File screenshotTargetDirectory = new File(screenshotAndHtmlSource.getScreenshotFile().getParent());
                File screenshotFile = new File(screenshotTargetDirectory, ((Screenshot)screenshot.get()).getFilename());
                return FileUtils.checksumCRC32((File)screenshotFile) == FileUtils.checksumCRC32((File)screenshotAndHtmlSource.getScreenshotFile());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to compare screenshots: " + e.getMessage());
        }
        return false;
    }

    private boolean haveIdenticalScreenshots(ScreenshotAndHtmlSource screenshotAndHtmlSource, ScreenshotAndHtmlSource anotherScreenshotAndHtmlSource) {
        if (this.noScreenshotIn(screenshotAndHtmlSource) || this.noScreenshotIn(anotherScreenshotAndHtmlSource)) {
            return false;
        }
        try {
            File screenshotTargetDirectory = new File(screenshotAndHtmlSource.getScreenshotFile().getParent());
            File screenshot = new File(screenshotTargetDirectory, screenshotAndHtmlSource.getScreenshotFile().getName());
            File anotherScreenshot = new File(screenshotTargetDirectory, anotherScreenshotAndHtmlSource.getScreenshotFile().getName());
            return FileUtils.checksumCRC32((File)screenshot) == FileUtils.checksumCRC32((File)anotherScreenshot);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to compare screenshots: " + e.getMessage());
            return false;
        }
    }

    private boolean noScreenshotIn(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource == null || screenshotAndHtmlSource.getScreenshotFile() == null;
    }

    private Optional<Screenshot> latestScreenshot() {
        List<Screenshot> screenshotsToDate = this.getCurrentTestOutcome().getScreenshots();
        if (!screenshotsToDate.isEmpty()) {
            return Optional.of((Object)screenshotsToDate.get(screenshotsToDate.size() - 1));
        }
        return Optional.absent();
    }

    private boolean browserIsOpen() {
        if (this.driver == null) {
            return false;
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).isInstantiated();
        }
        return this.driver.getCurrentUrl() != null;
    }

    private void takeInitialScreenshot() {
        if (this.currentStepExists() && this.screenshots().areAllowed(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    private Optional<ScreenshotAndHtmlSource> grabScreenshotFor(String testName) {
        String snapshotName = NameConverter.underscore(testName);
        Optional<File> screenshot = this.getPhotographer().takeScreenshot(snapshotName);
        if (screenshot.isPresent()) {
            if (this.shouldStoreSourcecode()) {
                File sourcecode = this.getPhotographer().getMatchingSourceCodeFor((File)screenshot.get());
                return Optional.of((Object)new ScreenshotAndHtmlSource((File)screenshot.get(), sourcecode));
            }
            return Optional.of((Object)new ScreenshotAndHtmlSource((File)screenshot.get()));
        }
        return Optional.absent();
    }

    private boolean shouldStoreSourcecode() {
        return this.configuration.storeHtmlSourceCode();
    }

    public Photographer getPhotographer() {
        ScreenshotBlurCheck blurCheck = new ScreenshotBlurCheck();
        if (blurCheck.blurLevel().isPresent()) {
            return new Photographer(this.driver, this.outputDirectory, (BlurLevel)((Object)blurCheck.blurLevel().get()));
        }
        return new Photographer(this.driver, this.outputDirectory);
    }

    private boolean shouldTakeEndOfStepScreenshotFor(TestResult result) {
        if (result == TestResult.FAILURE) {
            return this.screenshots().areAllowed(TakeScreenshots.FOR_FAILURES);
        }
        return this.screenshots().areAllowed(TakeScreenshots.AFTER_EACH_STEP);
    }

    @Override
    public List<TestOutcome> getTestOutcomes() {
        ArrayList sortedOutcomes = Lists.newArrayList(this.testOutcomes);
        Collections.sort(sortedOutcomes, this.byStartTimeAndName());
        return ImmutableList.copyOf((Collection)sortedOutcomes);
    }

    private Comparator<? super TestOutcome> byStartTimeAndName() {
        return new Comparator<TestOutcome>(){

            @Override
            public int compare(TestOutcome testOutcome1, TestOutcome testOutcome2) {
                String creationTimeAndName1 = testOutcome1.getStartTime().getMillis() + "_" + testOutcome1.getMethodName();
                String creationTimeAndName2 = testOutcome2.getStartTime().getMillis() + "_" + testOutcome2.getMethodName();
                return creationTimeAndName1.compareTo(creationTimeAndName2);
            }
        };
    }

    @Override
    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public boolean aStepHasFailed() {
        return !this.getTestOutcomes().isEmpty() && this.getCurrentTestOutcome().getTestFailureCause() != null;
    }

    @Override
    public Throwable getTestFailureCause() {
        return this.getCurrentTestOutcome().getTestFailureCause();
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        this.getCurrentTestOutcome().setTestFailureCause(cause);
    }

    @Override
    public void testIgnored() {
        if (this.getCurrentTestOutcome().getResult() != TestResult.PENDING) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
    }

    @Override
    public void notifyScreenChange() {
        if (this.screenshots().areAllowed(TakeScreenshots.FOR_EACH_ACTION)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    public void takeScreenshot() {
        this.take(ScreenshotType.MANDATORY_SCREENSHOT);
    }

    @Override
    public void useExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().useExamplesFrom(table);
        this.currentExample = 0;
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
        if (this.getCurrentTestOutcome().isDataDriven() && !this.getCurrentTestOutcome().dataIsPredefined()) {
            this.getCurrentTestOutcome().addRow(data);
        }
        ++this.currentExample;
        this.getEventBus().stepStarted(ExecutedStepDescription.withTitle(this.exampleTitle(this.currentExample, data)));
    }

    private String exampleTitle(int exampleNumber, Map<String, String> data) {
        return String.format("[%s] %s", exampleNumber, data);
    }

    @Override
    public void exampleFinished() {
        this.currentStepDone();
        this.getCurrentTestOutcome().moveToNextRow();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ScreenshotType {
        OPTIONAL_SCREENSHOT,
        MANDATORY_SCREENSHOT;

    }
}

