/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.thucydides.core.steps.DependencyInjector;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDependencyInjector
implements DependencyInjector {
    @Override
    public void injectDependenciesInto(Object target) {
        if (this.springIsOnClasspath() && this.annotatedWithSpringContext(target)) {
            TestContextManager contextManager = this.getTestContextManager(target.getClass());
            try {
                contextManager.prepareTestInstance(target);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate test instance", e);
            }
        }
    }

    private boolean annotatedWithSpringContext(Object target) {
        return target.getClass().getAnnotation(ContextConfiguration.class) != null;
    }

    private boolean springIsOnClasspath() {
        try {
            Class.forName("org.springframework.test.context.ContextConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected TestContextManager getTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }
}

