/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryTestResults {
    private List<TestOutcome> testOutcomes;
    private final String title;
    private final Story story;
    private final Configuration configuration;
    private final Formatter formatter;

    public StoryTestResults(Story story) {
        this(story, (Configuration)Injectors.getInjector().getInstance(Configuration.class), (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class));
    }

    public StoryTestResults(Story story, Configuration configuration, IssueTracking issueTracking) {
        this.configuration = configuration;
        this.testOutcomes = new ArrayList<TestOutcome>();
        this.title = story.getName();
        this.story = story;
        this.formatter = new Formatter(issueTracking);
    }

    public Story getStory() {
        return this.story;
    }

    public String getReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getNormalizedTestNameFor(this.getStory());
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public void recordTestRun(TestOutcome testOutcome) {
        this.testOutcomes.add(testOutcome);
    }

    public int countStepsInSuccessfulTests() {
        List successfulTests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess()));
        return this.countStepsIn(successfulTests);
    }

    public int countStepsInFailingTests() {
        List tests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure()));
        return this.countStepsIn(tests);
    }

    private int countStepsIn(List<TestOutcome> tests) {
        try {
            return tests.isEmpty() ? 0 : (Integer)Lambda.sum(tests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int countStepsInErrorTests() {
        List tests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isError()));
        return this.countStepsIn(tests);
    }

    public int countStepsInSkippedTests() {
        List tests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped()));
        return this.countStepsIn(tests);
    }

    public List<TestOutcome> getTestOutcomes() {
        return ImmutableList.copyOf(this.testOutcomes);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)this.title);
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    public String getFormattedIssues() {
        if (!this.getIssues().isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)Lambda.on(String.class));
            return "(" + this.getFormatter().addLinks(StringUtils.join((Iterable)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public Set<String> getIssues() {
        List allIssues = Lambda.flatten((Object)Lambda.extract(this.testOutcomes, ((TestOutcome)Lambda.on(TestOutcome.class)).getIssues()));
        return new HashSet<String>(allIssues);
    }

    private Formatter getFormatter() {
        return this.formatter;
    }

    public Double getCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.passingOrFailingSteps() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentPassingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.countStepsInSuccessfulTests() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentFailingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.countStepsInFailingTests() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentErrorCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.countStepsInErrorTests() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentPendingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)(this.getEstimatedTotalStepCount() - this.passingOrFailingSteps()) / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Integer getEstimatedTotalStepCount() {
        return this.getStepCount() + this.estimatedUnimplementedStepCount();
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    private int passingOrFailingSteps() {
        return this.countStepsInSuccessfulTests() + this.countStepsInFailingTests();
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return this.configuration.getEstimatedAverageStepCount();
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    private int totalImplementedTests() {
        int testCount = 0;
        for (TestOutcome testOutcome : this.testOutcomes) {
            if (testOutcome.getTestSteps().isEmpty()) continue;
            ++testCount;
        }
        return testCount;
    }

    public boolean containsResultsFor(Story aUserStory) {
        return this.getStory().equals(aUserStory);
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentPassingCoverage(), this.getPercentPendingCoverage(), this.getPercentFailingCoverage(), this.getPercentErrorCoverage());
    }

    public long getDuration() {
        return (Long)Lambda.sum(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getDuration());
    }

    public int getTotal() {
        return this.testOutcomes.size();
    }

    public TestResult getResult() {
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.getTestOutcomes(), (Converter)new ExtractTestResultsConverter());
    }

    public int getStepCount() {
        return Lambda.sum((Object)Lambda.extract(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount())).intValue();
    }

    public int getSuccessCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess())).size();
    }

    public int getFailureCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure())).size();
    }

    public int getPendingCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isPending())).size();
    }

    public Integer getSkipCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped())).size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestOutcome, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestOutcome step) {
            return step.getResult();
        }
    }
}

