/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.lang.reflect.Field;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WebElementFacadeImpl;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ElementLocatorFactorySelector;
import net.thucydides.core.webdriver.ElementProxyCreator;
import net.thucydides.core.webdriver.WebElementFacadeFieldDecorator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesElementProxyCreator
implements ElementProxyCreator {
    @Override
    public void proxyElements(PageObject pageObject, WebDriver driver, int timeoutInSeconds) {
        ElementLocatorFactory finder = this.getElementLocatorFactorySelector().withTimeout(timeoutInSeconds).getLocatorFor(driver);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
        this.initWebElementFacades(new WebElementFacadeFieldDecorator(finder), pageObject, driver);
    }

    @Override
    public void proxyElements(PageObject pageObject, WebDriver driver) {
        ElementLocatorFactory finder = this.getElementLocatorFactorySelector().getLocatorFor(driver);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
        this.initWebElementFacades(new WebElementFacadeFieldDecorator(finder), pageObject, driver);
    }

    private ElementLocatorFactorySelector getElementLocatorFactorySelector() {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        return new ElementLocatorFactorySelector(configuration);
    }

    private void initWebElementFacades(WebElementFacadeFieldDecorator decorator, PageObject page, WebDriver driver) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.proxyFields(decorator, page, proxyIn, driver);
        }
    }

    private void proxyFields(WebElementFacadeFieldDecorator decorator, PageObject page, Class<?> proxyIn, WebDriver driver) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            WebElement webElementValue = decorator.decorate(page.getClass().getClassLoader(), field);
            if (webElementValue == null) continue;
            try {
                WebElementFacadeImpl facadeValue = new WebElementFacadeImpl(driver, webElementValue, page.waitForTimeoutInMilliseconds());
                field.setAccessible(true);
                field.set(page, facadeValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

