/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.smart;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.thucydides.core.annotations.DelayElementLocation;
import net.thucydides.core.annotations.implementedBy;
import net.thucydides.core.pages.WebElementFacade;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartElementHandler
implements InvocationHandler {
    private final ElementLocator locator;
    private final WebDriver driver;
    private final Class<?> implementerClass;

    private Class<?> getImplementer(Class<?> interfaceType) {
        implementedBy implBy = interfaceType.getAnnotation(implementedBy.class);
        Class<?> implementerClass = implBy.value();
        if (!interfaceType.isAssignableFrom(implementerClass)) {
            throw new RuntimeException("implementer Class does not implement the interface " + interfaceType.getName());
        }
        return implementerClass;
    }

    public <T> SmartElementHandler(Class<T> interfaceType, ElementLocator locator, WebDriver driver) {
        this.driver = driver;
        this.locator = locator;
        if (!WebElementFacade.class.isAssignableFrom(interfaceType)) {
            throw new RuntimeException("interface not assignable to WebElementFacade");
        }
        this.implementerClass = this.getImplementer(interfaceType);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        try {
            if (method.isAnnotationPresent(DelayElementLocation.class)) {
                Constructor<?> constructor = this.implementerClass.getConstructor(WebDriver.class, ElementLocator.class, Long.TYPE);
                Object webElementFacadeExt = constructor.newInstance(this.driver, this.locator, 5000);
                return method.invoke(this.implementerClass.cast(webElementFacadeExt), objects);
            }
            WebElement element = this.locator.findElement();
            if ("getWrappedElement".equals(method.getName())) {
                return element;
            }
            Constructor<?> constructor = this.implementerClass.getConstructor(WebDriver.class, WebElement.class, Long.TYPE);
            Object webElementFacadeExt = constructor.newInstance(this.driver, element, 5000);
            return method.invoke(this.implementerClass.cast(webElementFacadeExt), objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

