/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.smart.findby;

import com.google.common.base.Function;
import java.util.List;
import java.util.NoSuchElementException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class SmartBy
extends By {
    public static SmartBy sclocator(String scLocator) {
        if (scLocator == null) {
            throw new IllegalArgumentException("Cannot find elements when the scLocator expression is null.");
        }
        return new ByScLocator(scLocator);
    }

    public static SmartBy jquery(String jQuerySelector) {
        if (jQuerySelector == null) {
            throw new IllegalArgumentException("Cannot find elements when the jQuerySelector expression is null.");
        }
        return new ByjQuerySelector(jQuerySelector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByjQuerySelector
    extends SmartBy {
        private final String jQuerySelector;

        public ByjQuerySelector(String jQuerySelector) {
            this.jQuerySelector = jQuerySelector;
        }

        public List<WebElement> findElements(SearchContext context) {
            List elements;
            try {
                elements = (List)new WebDriverWait((WebDriver)context, 1L).until((Function)new ExpectedCondition<List<WebElement>>(){

                    public List<WebElement> apply(WebDriver driver) {
                        try {
                            return (List)((JavascriptExecutor)driver).executeScript("var elements = $(arguments[0]).get(); return ((elements.length) ? elements : null)", new Object[]{ByjQuerySelector.this.jQuerySelector});
                        }
                        catch (WebDriverException e) {
                            return null;
                        }
                    }
                });
            }
            catch (TimeoutException e) {
                throw new NoSuchElementException("Cannot locate elements using " + this.toString());
            }
            return elements;
        }

        public WebElement findElement(SearchContext context) {
            WebElement element;
            try {
                element = (WebElement)new WebDriverWait((WebDriver)context, 1L).until((Function)new ExpectedCondition<WebElement>(){

                    public WebElement apply(WebDriver driver) {
                        try {
                            return (WebElement)((JavascriptExecutor)driver).executeScript("return $(arguments[0]).get(0)", new Object[]{ByjQuerySelector.this.jQuerySelector});
                        }
                        catch (WebDriverException e) {
                            return null;
                        }
                    }
                });
            }
            catch (TimeoutException e) {
                throw new NoSuchElementException("Cannot locate an element using " + this.toString());
            }
            return element;
        }

        public String toString() {
            return "By.jQuerySelector: " + this.jQuerySelector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByScLocator
    extends SmartBy {
        private final String scLocator;

        public ByScLocator(String scLocator) {
            this.scLocator = scLocator;
        }

        public List<WebElement> findElements(SearchContext context) {
            throw new IllegalArgumentException("SmartGWT does not provide the functionality to find multiple elements");
        }

        public WebElement findElement(SearchContext context) {
            WebElement element;
            try {
                element = (WebElement)new WebDriverWait((WebDriver)context, 1L).until((Function)new ExpectedCondition<WebElement>(){

                    public WebElement apply(WebDriver driver) {
                        try {
                            return (WebElement)((JavascriptExecutor)driver).executeScript("return AutoTest.getElement(arguments[0]);", new Object[]{ByScLocator.this.scLocator});
                        }
                        catch (WebDriverException e) {
                            return null;
                        }
                    }
                });
            }
            catch (TimeoutException e) {
                throw new NoSuchElementException("Cannot locate an element using " + this.toString());
            }
            return element;
        }

        public String toString() {
            return "By.sclocator: " + this.scLocator;
        }
    }
}

