/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.xml.TestOutcomeConverter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTestOutcomeReporter
implements AcceptanceTestReporter {
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTestOutcomeReporter.class);
    private transient String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        LOGGER.debug("Generating XML report for {}/{}", (Object)storedTestOutcome.getUserStory(), (Object)storedTestOutcome.getMethodName());
        LOGGER.debug("Test outcome contents = {}", (Object)storedTestOutcome);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.alias("acceptance-test-run", TestOutcome.class);
        xstream.registerConverter((Converter)this.usingXmlConverter());
        String xmlContents = xstream.toXML((Object)storedTestOutcome);
        String reportFilename = this.reportFor(storedTestOutcome);
        LOGGER.debug("Calculated report filename: {}", (Object)reportFilename);
        File report = new File(this.getOutputDirectory(), reportFilename);
        LOGGER.debug("Writing XML report to {}", (Object)report.getAbsolutePath());
        FileUtils.writeStringToFile((File)report, (String)xmlContents);
        return report;
    }

    private TestOutcomeConverter usingXmlConverter() {
        return new TestOutcomeConverter();
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TestOutcome> loadReportFrom(File reportFile) throws IOException {
        InputStream input = null;
        try {
            XStream xstream = new XStream();
            xstream.alias("acceptance-test-run", TestOutcome.class);
            xstream.registerConverter((Converter)this.usingXmlConverter());
            input = new FileInputStream(reportFile);
            Optional optional = Optional.of((Object)((TestOutcome)xstream.fromXML(input)));
            return optional;
        }
        catch (CannotResolveClassException e) {
            LOGGER.warn("Tried to load a file that is not a thucydides report: " + reportFile);
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            input.close();
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<TestOutcome> loadReportsFrom(File outputDirectory) throws IOException {
        File[] reportFiles = this.getAllXMLFilesFrom(outputDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        if (reportFiles != null) {
            for (File reportFile : reportFiles) {
                testOutcomes.addAll(this.loadReportFrom(reportFile).asSet());
            }
        }
        return testOutcomes;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new XmlFilenameFilter());
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

