/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.steps.StepEventBus;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.AjaxElementLocator;
import org.openqa.selenium.support.pagefactory.Annotations;

class DisplayedElementLocator
extends AjaxElementLocator {
    private static final List<String> QUICK_METHODS = Arrays.asList("isCurrentlyVisible", "isCurrentlyEnabled", "waitUntilVisible", "waitUntilEnabled", "shouldNotBeVisible");
    private static final List<String> QUICK_CLASSES = Arrays.asList(WebElementFacade.class.getName(), PageObject.class.getName());
    private final Field field;
    private final WebDriver driver;

    DisplayedElementLocator(WebDriver driver, Field field, int timeOutInSeconds) {
        super(driver, field, timeOutInSeconds);
        this.field = field;
        this.driver = driver;
    }

    public WebElement findElement() {
        if (this.shouldFindElementImmediately()) {
            return this.findElementImmediately();
        }
        return super.findElement();
    }

    private boolean shouldFindElementImmediately() {
        return StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed() || this.calledFromAQuickMethod();
    }

    private boolean calledFromAQuickMethod() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            if (!QUICK_METHODS.contains(elt.getMethodName()) || !QUICK_CLASSES.contains(elt.getClassName())) continue;
            return true;
        }
        return false;
    }

    public WebElement findElementImmediately() {
        Annotations annotations = new Annotations(this.field);
        By by = annotations.buildBy();
        List matchingElements = this.driver.findElements(by);
        if (matchingElements.isEmpty()) {
            throw new NoSuchElementException("No such element found for criteria " + by.toString());
        }
        return (WebElement)matchingElements.get(0);
    }

    protected boolean isElementUsable(WebElement element) {
        return element != null && element.isDisplayed();
    }
}

