/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.smart;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.webdriver.smart.SmartElementHandler;
import net.thucydides.core.webdriver.smart.findby.FindBy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartFieldDecorator
implements FieldDecorator {
    protected ElementLocatorFactory factory;
    protected WebDriver driver;

    public SmartFieldDecorator(ElementLocatorFactory factory, WebDriver driver) {
        this.driver = driver;
        this.factory = factory;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        if (WebElement.class.isAssignableFrom(fieldType)) {
            return this.proxyForLocator(loader, fieldType, locator);
        }
        if (List.class.isAssignableFrom(fieldType)) {
            Class erasureClass = this.getErasureClass(field);
            return this.proxyForListLocator(loader, erasureClass, locator);
        }
        return null;
    }

    private Class getErasureClass(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class erasureClass = this.getErasureClass(field);
        if (erasureClass == null || !WebElement.class.isAssignableFrom(erasureClass)) {
            return false;
        }
        return field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null;
    }

    protected <T> T proxyForLocator(ClassLoader loader, Class<T> interfaceType, ElementLocator locator) {
        Object proxy = null;
        if (WebElementFacade.class.isAssignableFrom(interfaceType)) {
            SmartElementHandler handler = new SmartElementHandler(interfaceType, locator, this.driver);
            proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceType}, (InvocationHandler)handler);
        } else {
            LocatingElementHandler handler = new LocatingElementHandler(locator);
            proxy = Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
        }
        return (T)proxy;
    }

    protected <T> List<T> proxyForListLocator(ClassLoader loader, Class<T> interfaceType, ElementLocator locator) {
        LocatingElementListHandler handler = new LocatingElementListHandler(locator);
        List proxy = (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
        return proxy;
    }
}

