/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.StoryTestResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStoriesResultSet {
    private final List<StoryTestResults> stories;

    public UserStoriesResultSet(List<StoryTestResults> stories) {
        this.stories = stories;
    }

    public List<StoryTestResults> getStories() {
        return ImmutableList.copyOf(this.stories);
    }

    public int getStoryCount() {
        return this.stories.size();
    }

    public int getTotalTestCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.getTotal();
        }
        return sum;
    }

    public int getSuccessCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.getSuccessCount();
        }
        return sum;
    }

    public int getFailureCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.getFailureCount();
        }
        return sum;
    }

    public int getPendingCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.getPendingCount();
        }
        return sum;
    }

    public Integer getTotalStepCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.getEstimatedTotalStepCount().intValue();
        }
        return sum;
    }

    public Integer getPassingStepCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.countStepsInSuccessfulTests();
        }
        return sum;
    }

    public Integer getFailingStepCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.countStepsInFailingTests();
        }
        return sum;
    }

    public Integer getErrorStepCount() {
        int sum = 0;
        for (StoryTestResults story : this.stories) {
            sum += story.countStepsInErrorTests();
        }
        return sum;
    }

    public Double getPercentageFailingStepCount() {
        return this.asPercentage(this.getFailingStepCount().intValue());
    }

    public Double getPercentageErrorStepCount() {
        return this.asPercentage(this.getErrorStepCount().intValue());
    }

    public Double getPercentagePassingStepCount() {
        return this.asPercentage(this.getPassingStepCount().intValue());
    }

    private Double asPercentage(double stepCount) {
        if (this.getTotalStepCount() > 0) {
            return this.roundedTo1DecimalPlace(stepCount / (double)this.getTotalStepCount().intValue());
        }
        return 0.0;
    }

    public Double getPercentagePendingStepCount() {
        return this.roundedTo1DecimalPlace(1.0 - this.getPercentageFailingStepCount() - this.getPercentagePassingStepCount());
    }

    private Double roundedTo1DecimalPlace(double value) {
        return BigDecimal.valueOf(value).setScale(3, 4).doubleValue();
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentagePassingStepCount(), this.getPercentagePendingStepCount(), this.getPercentageFailingStepCount(), this.getPercentageErrorStepCount());
    }
}

