/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.issues.IssueTracking;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final Pattern shortIssueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private static final String FULL_ISSUE_NUMBER_REGEXP = "([A-Z][A-Z0-9-_]*)-\\d+";
    private static final Pattern fullIssueNumberPattern = Pattern.compile("([A-Z][A-Z0-9-_]*)-\\d+");
    private static final String ISSUE_LINK_FORMAT = "<a target=\"_blank\" href=\"{0}\">{1}</a>";
    private static final String ELIPSE = "&hellip;";
    private final IssueTracking issueTracking;
    private final CharSequenceTranslator ESCAPE_SPECIAL_CHARS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_ESCAPE())});

    @Inject
    public Formatter(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
    }

    public static List<String> issuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        List<String> issuesWithHash = extractor.getShortenedIssues();
        List<String> allIssues = extractor.getFullIssues();
        allIssues.addAll(issuesWithHash);
        return allIssues;
    }

    public String addLinks(String value) {
        if (this.issueTracking == null) {
            return value;
        }
        String formattedValue = value;
        if (this.issueTracking.getIssueTrackerUrl() != null) {
            formattedValue = this.insertFullIssueTrackingUrls(value);
        }
        if (this.issueTracking.getShortenedIssueTrackerUrl() != null) {
            formattedValue = this.insertShortenedIssueTrackingUrls(formattedValue);
        }
        return formattedValue;
    }

    public String addLineBreaks(String text) {
        return text != null ? text.replaceAll("\r\n", "<br>").replaceAll("\n", "<br>") : "";
    }

    public String htmlCompatible(Object fieldValue) {
        return this.addLineBreaks(this.ESCAPE_SPECIAL_CHARS.translate((CharSequence)(fieldValue != null ? this.stringFormOf(fieldValue) : "")));
    }

    private String stringFormOf(Object fieldValue) {
        if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
            return "[" + Lambda.join((Object)fieldValue) + "]";
        }
        return fieldValue.toString();
    }

    public String truncatedHtmlCompatible(String text, int length) {
        return this.addLineBreaks(this.ESCAPE_SPECIAL_CHARS.translate((CharSequence)this.truncate(text, length)));
    }

    private String truncate(String text, int length) {
        if (text.length() > length) {
            return text.substring(0, length).trim() + ELIPSE;
        }
        return text;
    }

    private String insertShortenedIssueTrackingUrls(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getShortenedIssueTrackerUrl();
        List<String> issues = Formatter.shortenedIssuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    public static List<String> shortenedIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getShortenedIssues();
    }

    public static List<String> fullIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getFullIssues();
    }

    private String insertFullIssueTrackingUrls(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = Formatter.fullIssuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, issue);
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    public String formatWithFields(String textToFormat, List<String> fields) {
        String textWithEscapedFields = textToFormat;
        for (String field : fields) {
            textWithEscapedFields = textWithEscapedFields.replaceAll("<" + field + ">", "&lt;" + field + "&gt;");
        }
        return this.addLineBreaks(textWithEscapedFields);
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssueExtractor {
        private String workingCopy;

        IssueExtractor(String initialValue) {
            this.workingCopy = initialValue;
        }

        public List<String> getShortenedIssues() {
            Matcher matcher = shortIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (matcher.find()) {
                String issue = matcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }

        public List<String> getFullIssues() {
            Matcher unhashedMatcher = fullIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (unhashedMatcher.find()) {
                String issue = unhashedMatcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }
    }
}

