/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.templates.ReportTemplate;
import net.thucydides.core.reports.templates.TemplateManager;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HtmlReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private String resourceDirectory = "report-resources";
    private File outputDirectory;
    private final TemplateManager templateManager = (TemplateManager)Injectors.getInjector().getInstance(TemplateManager.class);
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReporter.class);
    private boolean alreadyCopied = false;

    public HtmlReporter() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public HtmlReporter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        if (!this.alreadyCopied) {
            this.updateResourceDirectoryFromSystemPropertyIfDefined();
            HtmlResourceCopier copier = new HtmlResourceCopier(this.getResourceDirectory());
            copier.copyHTMLResourcesTo(this.getOutputDirectory());
            this.alreadyCopied = true;
        }
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.REPORT_RESOURCE_PATH.getPropertyName());
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected File writeReportToOutputDirectory(String reportFilename, String htmlContents) throws IOException {
        File report = new File(this.getOutputDirectory(), reportFilename);
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = new FileOutputStream(report, false);
        try {
            if (report.length() < 1L) {
                byte[] bom = new byte[]{-17, -69, -65};
                fos.write(bom);
            }
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            if (htmlContents != null) {
                byte[] utf8Bytes = htmlContents.getBytes();
                String encodedString = new String(utf8Bytes, "UTF-8");
                bw.write(encodedString);
            }
            try {
                bw.close();
                fos.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            LOGGER.debug("Writing HTML report to {}", (Object)report.getAbsolutePath());
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                bw.close();
                fos.close();
            }
            catch (Exception ex) {}
        }
        return report;
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Merger {
        final String templateFile;

        public Merger(String templateFile) {
            this.templateFile = templateFile;
        }

        public String usingContext(Map<String, Object> context) {
            try {
                ReportTemplate template = HtmlReporter.this.getTemplateManager().getTemplateFrom(this.templateFile);
                StringWriter sw = new StringWriter();
                template.merge(context, sw);
                return sw.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to merge template: " + e.getMessage(), e);
            }
        }
    }
}

