/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Joiner;
import com.opera.core.systems.OperaDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SupportedWebDriver {
    FIREFOX(FirefoxDriver.class),
    CHROME(ChromeDriver.class),
    OPERA(OperaDriver.class),
    HTMLUNIT(HtmlUnitDriver.class),
    REMOTE(RemoteWebDriver.class),
    ANDROID(AndroidDriver.class),
    IPHONE(IPhoneDriver.class),
    IEXPLORER(InternetExplorerDriver.class),
    SAFARI(SafariDriver.class);

    private final Class<? extends WebDriver> webdriverClass;

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass) {
        this.webdriverClass = webdriverClass;
    }

    public Class<? extends WebDriver> getWebdriverClass() {
        return this.webdriverClass;
    }

    public static String listOfSupportedDrivers() {
        return Joiner.on((String)", ").join((Object[])SupportedWebDriver.values());
    }

    public static SupportedWebDriver getClosestDriverValueTo(String value) {
        SupportedWebDriver closestDriver = null;
        int closestDriverDistance = Integer.MAX_VALUE;
        for (SupportedWebDriver supportedDriver : SupportedWebDriver.values()) {
            int distance = StringUtils.getLevenshteinDistance((CharSequence)supportedDriver.toString(), (CharSequence)value);
            if (distance >= closestDriverDistance) continue;
            closestDriverDistance = distance;
            closestDriver = supportedDriver;
        }
        return closestDriver;
    }

    public static SupportedWebDriver getDriverTypeFor(String value) throws UnsupportedDriverException {
        try {
            return SupportedWebDriver.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SupportedWebDriver closestMatchingDriver = SupportedWebDriver.getClosestDriverValueTo(value);
            throw new UnsupportedDriverException("Unsupported browser type: " + value + ". Did you mean " + closestMatchingDriver.toString().toLowerCase() + "?", e);
        }
    }
}

