/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverInstances;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class ThucydidesWebdriverManager
implements WebdriverManager {
    private static final ThreadLocal<WebdriverInstances> webdriverInstancesThreadLocal = new ThreadLocal();
    private final WebDriverFactory webDriverFactory;
    private final Configuration configuration;
    private final Set<WebDriver> allWebdriverInstances;

    @Inject
    public ThucydidesWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
        this.allWebdriverInstances = Collections.synchronizedSet(new HashSet());
    }

    private static WebDriver newDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        SupportedWebDriver supportedDriverType = ThucydidesWebdriverManager.getConfiguredWebDriverWithOverride(configuration, driver);
        Class<? extends WebDriver> webDriverType = webDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType, webDriverFactory);
    }

    private static SupportedWebDriver getConfiguredWebDriverWithOverride(Configuration configuration, String driver) {
        if (StringUtils.isEmpty((CharSequence)driver)) {
            return configuration.getDriverType();
        }
        return SupportedWebDriver.getDriverTypeFor(driver);
    }

    public void closeDriver() {
        WebDriver driver = ThucydidesWebdriverManager.inThisTestThread().closeCurrentDriver();
        if (driver != null) {
            this.allWebdriverInstances.remove(driver);
        }
    }

    public void closeAllCurrentDrivers() {
        Set<WebDriver> closedDrivers = ThucydidesWebdriverManager.inThisTestThread().closeAllDrivers();
        this.allWebdriverInstances.removeAll(closedDrivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllDrivers() {
        Set<WebDriver> set = this.allWebdriverInstances;
        synchronized (set) {
            for (WebDriver driver : this.allWebdriverInstances) {
                this.closeSafely(driver);
            }
            this.allWebdriverInstances.clear();
        }
    }

    private void closeSafely(WebDriver driver) {
        try {
            driver.close();
            driver.quit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetDriver() {
        ThucydidesWebdriverManager.inThisTestThread().resetCurrentDriver();
    }

    public WebDriver getWebdriver() {
        return ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory, ThucydidesWebdriverManager.inThisTestThread().getCurrentDriverName());
    }

    public SessionId getSessionId() {
        WebDriver driver = ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory, ThucydidesWebdriverManager.inThisTestThread().getCurrentDriverName());
        if (driver instanceof RemoteWebDriver) {
            return ((RemoteWebDriver)driver).getSessionId();
        }
        return null;
    }

    public WebDriver getWebdriver(String driverName) {
        WebDriver activeDriver = StringUtils.isEmpty((CharSequence)driverName) ? this.getWebdriver() : ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory, driverName);
        this.registerDriverInGlobalDrivers(activeDriver);
        return activeDriver;
    }

    private void registerDriverInGlobalDrivers(WebDriver activeDriver) {
        this.allWebdriverInstances.add(activeDriver);
    }

    private static WebDriver getThreadLocalWebDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        if (!ThucydidesWebdriverManager.inThisTestThread().driverIsRegisteredFor(driver)) {
            ThucydidesWebdriverManager.inThisTestThread().registerDriverCalled(driver).forDriver(ThucydidesWebdriverManager.newDriver(configuration, webDriverFactory, driver));
        }
        return ThucydidesWebdriverManager.inThisTestThread().useDriver(driver);
    }

    private static WebdriverInstances inThisTestThread() {
        if (webdriverInstancesThreadLocal.get() == null) {
            webdriverInstancesThreadLocal.set(new WebdriverInstances());
        }
        return webdriverInstancesThreadLocal.get();
    }

    public int getCurrentActiveWebdriverCount() {
        return ThucydidesWebdriverManager.inThisTestThread().getActiveWebdriverCount();
    }

    public int getActiveWebdriverCount() {
        return this.allWebdriverInstances.size();
    }
}

