/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.Inflector;

public class HtmlRequirementsReporter
extends HtmlReporter {
    private static final String DEFAULT_REQUIREMENTS_REPORT = "freemarker/capabilities.ftl";
    private static final String REPORT_NAME = "capabilities.html";
    private final IssueTracking issueTracking;

    public HtmlRequirementsReporter() {
        this((IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class));
    }

    public HtmlRequirementsReporter(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        return this.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), REPORT_NAME);
    }

    public File generateReportFor(RequirementsOutcomes requirementsOutcomes, TestOutcomes testOutcomes, String filename) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("requirements", requirementsOutcomes);
        context.put("testOutcomes", requirementsOutcomes.getTestOutcomes());
        context.put("allTestOutcomes", testOutcomes);
        context.put("reportName", new ReportNameProvider());
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_REQUIREMENTS_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        return this.writeReportToOutputDirectory(filename, htmlContents);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
    }
}

