/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;

public class RequirementsPath {
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[\\\\/.]");
    private static final Pattern FILE_SYSTEM_PATH_SEPARATORS = Pattern.compile("[\\\\/]");

    public static List<String> stripRootFromPath(String root, List<String> storyPathElements) {
        List<String> rootElements = RequirementsPath.pathElements(root);
        if (((Object)storyPathElements.subList(0, rootElements.size())).equals(rootElements)) {
            return storyPathElements.subList(rootElements.size(), storyPathElements.size());
        }
        return storyPathElements;
    }

    public static List<String> pathElements(String path) {
        return IteratorUtils.toList(Splitter.on((Pattern)PATH_SEPARATORS).omitEmptyStrings().trimResults().split((CharSequence)path).iterator());
    }

    public static List<String> fileSystemPathElements(String path) {
        return IteratorUtils.toList(Splitter.on((Pattern)FILE_SYSTEM_PATH_SEPARATORS).omitEmptyStrings().trimResults().split((CharSequence)path).iterator());
    }
}

