/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.DelayElementLocation;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.HtmlTag;
import net.thucydides.core.pages.InternalSystemClock;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementFacadeImpl
implements WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long timeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavascriptExecutorFacade javascriptExecutorFacade;
    private InternalSystemClock clock = new InternalSystemClock();
    private final EnvironmentVariables environmentVariables;
    private ElementLocator locator;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebElementFacadeImpl.class);
    private final List<String> HTML_FORM_TAGS = Arrays.asList("input", "button", "select", "textarea", "link", "option");
    private static final List<String> HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE = ImmutableList.of((Object)"input", (Object)"button", (Object)"option");

    public WebElementFacadeImpl(WebDriver driver, WebElement webElement, long timeoutInMilliseconds) {
        this.driver = driver;
        this.webElement = webElement;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, long timeoutInMilliseconds) {
        this.driver = driver;
        this.locator = locator;
        this.webElement = null;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public WebElement getElement() {
        if (this.webElement != null) {
            return this.webElement;
        }
        if (this.locator == null) {
            return null;
        }
        return this.locator.findElement();
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        return this.javascriptExecutorFacade;
    }

    protected InternalSystemClock getClock() {
        return this.clock;
    }

    @Override
    public WebElementFacade then(String xpathOrCssSelector) {
        return this.findBy(xpathOrCssSelector);
    }

    @Override
    public WebElementFacade findBy(String xpathOrCssSelector) {
        this.logIfVerbose("findBy " + xpathOrCssSelector);
        WebElement nestedElement = PageObject.isXPath(xpathOrCssSelector) ? this.webElement.findElement(By.xpath((String)xpathOrCssSelector)) : this.webElement.findElement(By.cssSelector((String)xpathOrCssSelector));
        return new WebElementFacadeImpl(this.driver, nestedElement, this.timeoutInMilliseconds);
    }

    @Override
    public List<WebElementFacade> thenFindAll(String xpathOrCssSelector) {
        this.logIfVerbose("findAll " + xpathOrCssSelector);
        List nestedElements = Lists.newArrayList();
        nestedElements = PageObject.isXPath(xpathOrCssSelector) ? this.webElement.findElements(By.xpath((String)xpathOrCssSelector)) : this.webElement.findElements(By.cssSelector((String)xpathOrCssSelector));
        return this.webElementFacadesFrom(nestedElements);
    }

    private List<WebElementFacade> webElementFacadesFrom(List<WebElement> nestedElements) {
        ArrayList results = Lists.newArrayList();
        for (WebElement element : nestedElements) {
            results.add(new WebElementFacadeImpl(this.driver, element, this.timeoutInMilliseconds));
        }
        return results;
    }

    @Override
    public WebElementFacade findBy(By selector) {
        this.logIfVerbose("findBy " + selector);
        WebElement nestedElement = this.webElement.findElement(selector);
        return new WebElementFacadeImpl(this.driver, nestedElement, this.timeoutInMilliseconds);
    }

    @Override
    public WebElementFacade find(By bySelector) {
        return this.findBy(bySelector);
    }

    @Override
    public WebElementFacade then(By bySelector) {
        return this.findBy(bySelector);
    }

    @Override
    public String getAttribute(String name) {
        return this.webElement.getAttribute(name);
    }

    @Override
    public List<WebElementFacade> thenFindAll(By selector) {
        this.logIfVerbose("findAll " + selector);
        List nestedElements = this.webElement.findElements(selector);
        return this.webElementFacadesFrom(nestedElements);
    }

    @Override
    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    @Override
    public WebElementFacade withTimeoutOf(int timeout, TimeUnit unit) {
        return new WebElementFacadeImpl(this.driver, this.webElement, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    @Override
    public boolean isVisible() {
        try {
            return this.getElement() != null && this.getElement().isDisplayed();
        }
        catch (ElementNotVisibleException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    @Override
    public WebElementFacade and() {
        return this;
    }

    @Override
    public WebElementFacade then() {
        return this;
    }

    @Override
    @DelayElementLocation
    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    @Override
    public boolean isCurrentlyEnabled() {
        try {
            return this.getElement().isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    @Override
    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    @Override
    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    @Override
    public void shouldNotBeVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    @Override
    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    @Override
    public boolean hasFocus() {
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.webElement.equals(activeElement);
    }

    @Override
    public boolean containsText(String value) {
        return this.webElement != null && this.webElement.getText().contains(value);
    }

    @Override
    public boolean containsOnlyText(String value) {
        return this.webElement != null && this.webElement.getText().equals(value);
    }

    @Override
    public boolean containsSelectOption(String value) {
        return this.getSelectOptions().contains(value);
    }

    @Override
    public List<String> getSelectOptions() {
        List results = Collections.emptyList();
        if (this.webElement != null) {
            results = this.webElement.findElements(By.tagName((String)"option"));
        }
        return Lambda.convert((Object)results, (Converter)new ExtractText());
    }

    @Override
    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element. Element text '%s'.", textValue, this.webElement.getText());
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public void shouldContainOnlyText(String textValue) {
        if (!this.containsOnlyText(textValue)) {
            String errorMessage = String.format("The text '%s' does not match the elements text '%s'.", textValue, this.webElement.getText());
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public void shouldContainSelectedOption(String textValue) {
        if (!this.containsSelectOption(textValue)) {
            String errorMessage = String.format("The list element '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was found in the web element when it should not have. Element text '%s'.", textValue, this.webElement.getText());
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.webElement != null && this.webElement.isEnabled();
    }

    @Override
    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public WebElementFacade type(String value) {
        this.logIfVerbose("Type '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        this.notifyScreenChange();
        return this;
    }

    @Override
    public WebElementFacade typeAndEnter(String value) {
        this.logIfVerbose("Type and enter '" + value + "'");
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value, Keys.ENTER});
        this.notifyScreenChange();
        return this;
    }

    @Override
    public WebElementFacade typeAndTab(String value) {
        this.logIfVerbose("Type and tab '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        this.webElement.sendKeys(new CharSequence[]{Keys.TAB});
        this.getClock().pauseFor(100L);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public void setWindowFocus() {
        this.getJavascriptExecutorFacade().executeScript("window.focus()");
    }

    @Override
    public WebElementFacade selectByVisibleText(String label) {
        this.logIfVerbose("Select label '" + label + "'");
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByVisibleText(label);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public String getSelectedVisibleTextValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getText();
    }

    @Override
    public WebElementFacade selectByValue(String value) {
        this.logIfVerbose("Select value '" + value + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByValue(value);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public String getSelectedValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getAttribute("value");
    }

    @Override
    public WebElementFacade selectByIndex(int indexValue) {
        this.logIfVerbose("Select by index '" + indexValue + "'");
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByIndex(indexValue);
        this.notifyScreenChange();
        return this;
    }

    private void waitUntilElementAvailable() {
        if (this.driverIsDisabled()) {
            return;
        }
        this.waitUntilEnabled();
    }

    private boolean driverIsDisabled() {
        return StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    @Override
    public boolean isPresent() {
        if (this.driverIsDisabled()) {
            return false;
        }
        try {
            return this.getElement() != null && (this.getElement().isDisplayed() || !this.getElement().isDisplayed());
        }
        catch (NoSuchElementException e) {
            return e.getCause().getMessage().contains("Element is not usable");
        }
    }

    @Override
    public void shouldBePresent() {
        if (!this.isPresent()) {
            String errorMessage = String.format("Field should be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public void shouldNotBePresent() {
        if (this.isPresent()) {
            String errorMessage = String.format("Field should not be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    @Override
    public WebElementFacade waitUntilVisible() {
        if (this.driverIsDisabled()) {
            return this;
        }
        try {
            this.waitForCondition().until(this.elementIsDisplayed());
        }
        catch (Throwable error) {
            this.throwErrorWithCauseIfPresent(error, error.getMessage());
        }
        return this;
    }

    @Override
    public WebElementFacade waitUntilPresent() {
        if (this.driverIsDisabled()) {
            return this;
        }
        try {
            this.waitForCondition().until(this.elementIsPresent());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    private void throwErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementNotVisibleException(finalMessage, timeout);
    }

    private ExpectedCondition<Boolean> elementIsDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return WebElementFacadeImpl.this.getElement() != null && WebElementFacadeImpl.this.getElement().isDisplayed();
                }
                catch (NullPointerException e) {
                    return false;
                }
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.isPresent();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacadeImpl.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.webElement != null && !WebElementFacadeImpl.this.isDisabledField(WebElementFacadeImpl.this.webElement);
            }
        };
    }

    private boolean isDisabledField(WebElement webElement) {
        return this.isAFormElement(webElement) && !webElement.isEnabled();
    }

    private boolean isAFormElement(WebElement webElement) {
        if (webElement == null || webElement.getTagName() == null) {
            return false;
        }
        String tag = webElement.getTagName().toLowerCase();
        return this.HTML_FORM_TAGS.contains(tag);
    }

    private boolean hasValueAttribute(WebElement webElement) {
        String tag = webElement.getTagName().toLowerCase();
        return HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE.contains(tag);
    }

    private ExpectedCondition<Boolean> elementIsNotEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacadeImpl.this.webElement != null && !WebElementFacadeImpl.this.webElement.isEnabled();
            }
        };
    }

    @Override
    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.timeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    @Override
    public WebElementFacade waitUntilNotVisible() {
        if (this.driverIsDisabled()) {
            return this;
        }
        try {
            this.waitForCondition().until(this.elementIsNotDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
        return this;
    }

    @Override
    public String getValue() {
        this.waitUntilVisible();
        return this.webElement.getAttribute("value");
    }

    @Override
    public boolean isSelected() {
        this.waitUntilVisible();
        return this.webElement.isSelected();
    }

    @Override
    public String getText() {
        this.waitUntilVisible();
        return this.webElement.getText();
    }

    @Override
    public WebElementFacade waitUntilEnabled() {
        if (this.driverIsDisabled()) {
            return this;
        }
        try {
            this.waitForCondition().until(this.elementIsEnabled());
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected enabled element " + this + "was not enabled", (Throwable)timeout);
        }
    }

    @Override
    public WebElementFacade waitUntilDisabled() {
        if (this.driverIsDisabled()) {
            return this;
        }
        try {
            this.waitForCondition().until(this.elementIsNotEnabled());
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected disabled element " + this + "  was not disabled", (Throwable)timeout);
        }
    }

    @Override
    public String getTextValue() {
        this.waitUntilPresent();
        if (!this.isVisible()) {
            return "";
        }
        if (this.valueAttributeSupportedAndDefinedIn(this.webElement)) {
            return this.getValue();
        }
        if (!StringUtils.isEmpty((CharSequence)this.webElement.getText())) {
            return this.webElement.getText();
        }
        return "";
    }

    private boolean valueAttributeSupportedAndDefinedIn(WebElement webElement) {
        return this.hasValueAttribute(webElement) && StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    @Override
    public void click() {
        this.enableHighlightingIfRequired();
        this.waitUntilElementAvailable();
        this.logClick();
        this.webElement.click();
        this.notifyScreenChange();
    }

    private void logClick() {
        this.logIfVerbose("click");
    }

    private void logIfVerbose(String logMessage) {
        if (this.useVerboseLogging()) {
            LOGGER.info(this.humanizedTabfNameFor(this.webElement) + ":" + logMessage);
        }
    }

    private boolean useVerboseLogging() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.VERBOSE_STEPS.getPropertyName(), false);
    }

    private EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    private String humanizedTabfNameFor(WebElement webElement) {
        return HtmlTag.from(webElement).inHumanReadableForm();
    }

    @Override
    public void clear() {
        this.webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.DELETE});
        this.webElement.clear();
    }

    private void enableHighlightingIfRequired() {
        JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.driver);
        if (jQueryEnabledPage.isJQueryEnabled()) {
            jQueryEnabledPage.injectJQueryPlugins();
        }
    }

    private void notifyScreenChange() {
        StepEventBus.getEventBus().notifyScreenChange();
    }

    @Override
    public String toString() {
        if (this.webElement != null) {
            return this.webElement.toString();
        }
        return "<Undefined web element>";
    }

    public void submit() {
        this.webElement.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.webElement.sendKeys(keysToSend);
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public List<WebElement> findElements(By by) {
        return this.webElement.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.webElement.findElement(by);
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public Point getLocation() {
        return this.webElement.getLocation();
    }

    public Dimension getSize() {
        return this.webElement.getSize();
    }

    public String getCssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    public WebElement getWrappedElement() {
        return this.webElement;
    }

    public Coordinates getCoordinates() {
        return ((Locatable)this.webElement).getCoordinates();
    }

    @Deprecated
    public Point getLocationOnScreenOnceScrolledIntoView() {
        return ((Locatable)this.webElement).getLocationOnScreenOnceScrolledIntoView();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtractText
    implements Converter<WebElement, String> {
        ExtractText() {
        }

        public String convert(WebElement from) {
            return from.getText();
        }
    }
}

