/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCaseAnnotations {
    private final Object testCase;

    private TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        Optional<ManagedWebDriverAnnotatedField> webDriverField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(this.testCase.getClass());
        if (webDriverField.isPresent()) {
            ((ManagedWebDriverAnnotatedField)webDriverField.get()).setValue(this.testCase, driver);
        }
    }

    public static boolean supportsWebTests(Class clazz) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(clazz);
    }

    public boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession(this.testCase.getClass());
    }

    public static boolean isUniqueSession(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.isUniqueSession();
    }

    public static boolean isWebTest(Class<?> testClass) {
        return ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass).isPresent();
    }
}

