/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.csv;

import au.com.bytecode.opencsv.CSVWriter;
import ch.lambdaj.Lambda;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReporter
extends ThucydidesReporter {
    private static final String[] TITLE_LINE = new String[]{"Story", "Title", "Result", "Date", "Stability", "Duration (s)"};
    private static final String[] OF_STRINGS = new String[0];
    private final List<String> extraColumns;

    public CSVReporter(File outputDirectory) {
        this(outputDirectory, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public CSVReporter(File outputDirectory, EnvironmentVariables environmentVariables) {
        this.setOutputDirectory(outputDirectory);
        this.extraColumns = this.extraColumnsDefinedIn(environmentVariables);
    }

    private List<String> extraColumnsDefinedIn(EnvironmentVariables environmentVariables) {
        String columns = ThucydidesSystemProperty.THUCYDIDES_EXTRA_COLUMNS.from(environmentVariables, "");
        return ImmutableList.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)columns));
    }

    public File generateReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(this.getOutputFile(reportName)));
        this.writeTitleRow(writer);
        this.writeEachRow(testOutcomes.withHistory(), writer);
        writer.close();
        return this.getOutputFile(reportName);
    }

    private void writeTitleRow(CSVWriter writer) {
        Inflector inflector = Inflector.getInstance();
        ArrayList<String> titles = new ArrayList<String>();
        titles.addAll(Arrays.asList(TITLE_LINE));
        for (String extraColumn : this.extraColumns) {
            titles.add(inflector.of(extraColumn).asATitle().toString());
        }
        writer.writeNext(titles.toArray(OF_STRINGS));
    }

    private void writeEachRow(TestOutcomes testOutcomes, CSVWriter writer) {
        for (TestOutcome testOutcome : testOutcomes.getTests()) {
            writer.writeNext(this.withRowDataFrom(testOutcome));
        }
    }

    private Double passRateFor(TestOutcome outcome) {
        return outcome.getStatistics().getPassRate().overTheLast(5).testRuns();
    }

    private String[] withRowDataFrom(TestOutcome outcome) {
        ImmutableList defaultValues = ImmutableList.of((Object)outcome.getStoryTitle(), (Object)outcome.getTitle(), (Object)((Object)outcome.getResult()), (Object)outcome.getStartTime(), (Object)this.passRateFor(outcome), (Object)outcome.getDurationInSeconds());
        List cellValues = Lambda.extract((Object)defaultValues, (Object)Lambda.on(Object.class).toString());
        cellValues.addAll(this.extraValuesFrom(outcome));
        return cellValues.toArray(OF_STRINGS);
    }

    private Collection<String> extraValuesFrom(TestOutcome outcome) {
        ArrayList extraValues = Lists.newArrayList();
        for (String extraColumn : this.extraColumns) {
            extraValues.add(outcome.getTagValue(extraColumn).or((Object)""));
        }
        return extraValues;
    }

    private File getOutputFile(String reportName) {
        return new File(this.getOutputDirectory(), reportName);
    }
}

