/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.templates.ReportTemplate;
import net.thucydides.core.reports.templates.TemplateManager;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.io.FileUtils;

public abstract class HtmlReporter
extends ThucydidesReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private String resourceDirectory = "report-resources";
    private final TemplateManager templateManager = (TemplateManager)Injectors.getInjector().getInstance(TemplateManager.class);
    private final EnvironmentVariables environmentVariables;
    private boolean alreadyCopied = false;

    public HtmlReporter() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public HtmlReporter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        if (!this.alreadyCopied) {
            this.updateResourceDirectoryFromSystemPropertyIfDefined();
            HtmlResourceCopier copier = new HtmlResourceCopier(this.getResourceDirectory());
            copier.copyHTMLResourcesTo(this.getOutputDirectory());
            this.alreadyCopied = true;
        }
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.REPORT_RESOURCE_PATH.getPropertyName());
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected File writeReportToOutputDirectory(String reportFilename, String htmlContents) throws IOException {
        File report = new File(this.getOutputDirectory(), reportFilename);
        FileUtils.writeStringToFile((File)report, (String)htmlContents, (Charset)Charset.forName("UTF-8"));
        return report;
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Merger {
        final String templateFile;

        public Merger(String templateFile) {
            this.templateFile = templateFile;
        }

        public String usingContext(Map<String, Object> context) {
            try {
                ReportTemplate template = HtmlReporter.this.getTemplateManager().getTemplateFrom(this.templateFile);
                StringWriter sw = new StringWriter();
                template.merge(context, sw);
                return sw.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to merge template: " + e.getMessage(), e);
            }
        }
    }
}

