/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.List;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.model.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;
    private final int requirementsWithoutTests;
    private final int estimatedUnimplementedTests;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, int requirementsWithoutTests, int estimatedUnimplementedTests, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.requirementsWithoutTests = requirementsWithoutTests;
        this.estimatedUnimplementedTests = estimatedUnimplementedTests;
        this.issueTracking = issueTracking;
    }

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this(requirement, testOutcomes, 0, 0, issueTracking);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public boolean isComplete() {
        return this.getTestOutcomes().getResult() == TestResult.SUCCESS && this.allChildRequirementsAreSuccessful();
    }

    public boolean isFailure() {
        return this.getTestOutcomes().getResult() == TestResult.FAILURE || this.anyChildRequirementsAreFailures();
    }

    public boolean isPending() {
        return this.getTestOutcomes().getResult() == TestResult.PENDING || this.anyChildRequirementsArePending();
    }

    public int getFlattenedRequirementCount() {
        return this.requirement.getNestedChildren().size() + 1;
    }

    public int getRequirementsWithoutTestsCount() {
        return this.requirementsWithoutTests;
    }

    private boolean allChildRequirementsAreSuccessful() {
        if (this.requirement.hasChildren()) {
            return this.allChildRequirementsAreSuccessfulFor(this.requirement.getChildren());
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailures() {
        return this.anyChildRequirementsAreFailuresFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsArePending() {
        return this.anyChildRequirementsArePendingFor(this.requirement.getChildren());
    }

    private boolean allChildRequirementsAreSuccessfulFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (!childOutcomes.isComplete()) {
                return false;
            }
            if (this.allChildRequirementsAreSuccessfulFor(childRequirement.getChildren())) continue;
            return false;
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailuresFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isFailure()) {
                return true;
            }
            if (!this.anyChildRequirementsAreFailuresFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsArePendingFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isPending()) {
                return true;
            }
            if (!this.anyChildRequirementsArePendingFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return this.getFormatter().addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }

    public double getPercentagePassingTestCount() {
        return (double)this.getPassingTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public int getTestCount() {
        return this.testOutcomes.getTotal();
    }

    public int getPassingTestCount() {
        return this.testOutcomes.getSuccessCount();
    }

    public double getPercentageFailingTestCount() {
        return (double)this.getFailingTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public double getPercentageErrorTestCount() {
        return (double)this.getErrorTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public int getEstimatedUnimplementedTests() {
        return this.estimatedUnimplementedTests;
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.testOutcomes.getTotal();
        return totalImplementedTests + this.estimatedUnimplementedTests;
    }

    public int getFailingTestCount() {
        return this.testOutcomes.getFailureCount();
    }

    public int getErrorTestCount() {
        return this.testOutcomes.getErrorCount();
    }

    public int getPendingTestCount() {
        return this.testOutcomes.getPendingCount();
    }

    public double getPercentagePendingTestCount() {
        return 1.0 - this.getPercentageFailingTestCount() - this.getPercentagePassingTestCount();
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentagePassingTestCount(), this.getPercentagePendingTestCount(), this.getPercentageFailingTestCount(), this.getPercentageErrorTestCount());
    }

    public boolean testsRequirement(Requirement requirement) {
        return requirement.equals(this.getRequirement()) || this.testOutcomes.containsTag(requirement.asTag());
    }
}

