/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import ch.lambdaj.Lambda;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.tags.TagConverters;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagScanner {
    private final EnvironmentVariables environmentVariables;

    public TagScanner(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean shouldRunClass(Class<?> testClass) {
        List<TestTag> expectedTags = this.expectedTags();
        if (expectedTags.isEmpty()) {
            return true;
        }
        return this.testClassContainsAtLeastOneExpectedTag(testClass, expectedTags);
    }

    public boolean shouldRunMethod(Class<?> testClass, String methodName) {
        List<TestTag> expectedTags = this.expectedTags();
        if (expectedTags.isEmpty()) {
            return true;
        }
        return this.testMethodContainsAtLeastOneExpectedTag(testClass, methodName, expectedTags);
    }

    private boolean testClassContainsAtLeastOneExpectedTag(Class<?> testClass, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTags();
        return this.tagsMatch(expectedTags, tags);
    }

    private boolean testMethodContainsAtLeastOneExpectedTag(Class<?> testClass, String methodName, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return this.tagsMatch(expectedTags, tags);
    }

    private boolean tagsMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        for (TestTag expectedTag : expectedTags) {
            if (!tags.contains(expectedTag)) continue;
            return true;
        }
        return false;
    }

    private List<TestTag> expectedTags() {
        String tagListValue = this.environmentVariables.getProperty(ThucydidesSystemProperty.TAGS);
        if (StringUtils.isNotEmpty((CharSequence)tagListValue)) {
            ArrayList tagList = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)tagListValue));
            return Lambda.convert((Object)tagList, TagConverters.fromStringValuesToTestTags());
        }
        return Lists.newArrayList();
    }
}

