/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.xunit;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.adaptors.TestOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.xunit.BasicXUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.XUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.io.XUnitFiles;
import net.thucydides.core.reports.adaptors.xunit.model.TestCase;
import net.thucydides.core.reports.adaptors.xunit.model.TestException;
import net.thucydides.core.reports.adaptors.xunit.model.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXUnitAdaptor
implements TestOutcomeAdaptor {
    private final XUnitLoader loader = new BasicXUnitLoader();

    @Override
    public List<TestOutcome> loadOutcomesFrom(File directory) throws IOException {
        ArrayList loadedOutcomes = Lists.newArrayList();
        for (File xunitFile : XUnitFiles.in(directory)) {
            loadedOutcomes.addAll(this.testOutcomesIn(xunitFile));
        }
        return ImmutableList.copyOf((Collection)loadedOutcomes);
    }

    private List<TestOutcome> testOutcomesIn(File xunitFile) throws IOException {
        List<TestSuite> xunitTestSuites = this.loader.loadFrom(xunitFile);
        ArrayList testOutcomes = Lists.newArrayList();
        for (TestSuite testSuite : xunitTestSuites) {
            testOutcomes.addAll(this.testOutcomesIn(testSuite));
        }
        return ImmutableList.copyOf((Collection)testOutcomes);
    }

    private Collection<? extends TestOutcome> testOutcomesIn(TestSuite testSuite) {
        return Lambda.convert(testSuite.getTestCases(), this.toTestOutcomes());
    }

    private Converter<TestCase, TestOutcome> toTestOutcomes() {
        return new Converter<TestCase, TestOutcome>(){

            public TestOutcome convert(TestCase from) {
                TestException failure;
                TestOutcome outcome = TestOutcome.forTestInStory(from.getName(), Story.called(from.getClassname()));
                outcome.setDuration(DefaultXUnitAdaptor.this.timeAsLong(from.getTime()));
                if (from.getError().isPresent()) {
                    failure = (TestException)from.getError().get();
                    outcome.setTestFailureCause(failure.asException());
                }
                if (from.getFailure().isPresent()) {
                    failure = (TestException)from.getFailure().get();
                    outcome.setTestFailureCause(failure.asAssertionFailure());
                }
                return outcome;
            }
        };
    }

    private long timeAsLong(double time) {
        return time < 1.0 ? 1L : (long)time;
    }
}

