/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcomeConverter
implements Converter {
    private static final String TITLE_FIELD = "title";
    private static final String NAME_FIELD = "name";
    private static final String ID_FIELD = "id";
    private static final String PATH_FIELD = "path";
    private static final String STEPS_FIELD = "steps";
    private static final String SUCCESSFUL_FIELD = "successful";
    private static final String FAILURES_FIELD = "failures";
    private static final String ERRORS_FIELD = "errors";
    private static final String SKIPPED_FIELD = "skipped";
    private static final String IGNORED_FIELD = "ignored";
    private static final String PENDING_FIELD = "pending";
    private static final String RESULT_FIELD = "result";
    private static final String TEST_GROUP = "test-group";
    private static final String TEST_STEP = "test-step";
    private static final String USER_STORY = "user-story";
    private static final String FEATURE = "feature";
    private static final String ISSUES = "issues";
    private static final String ISSUE = "issue";
    private static final String TAGS = "tags";
    private static final String TAG = "tag";
    private static final String QUALIFIER_FIELD = "qualifier";
    private static final String TAG_NAME = "name";
    private static final String TAG_TYPE = "type";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    private static final String SCREENSHOT_LIST_FIELD = "screenshots";
    private static final String SCREENSHOT_FIELD = "screenshot";
    private static final String SCREENSHOT_IMAGE = "image";
    private static final String SCREENSHOT_SOURCE = "source";
    private static final String DESCRIPTION = "description";
    private static final String DURATION = "duration";
    private static final String TIMESTAMP = "timestamp";
    private static final String SESSION_ID = "session-id";
    private static final String EXAMPLES = "examples";
    private static final String HEADERS = "headers";
    private static final String HEADER = "header";
    private static final String ROWS = "rows";
    private static final String ROW = "row";
    private static final String VALUE = "value";
    public static final String NEW_LINE_CHAR = "\n";
    public static final String ESCAPE_CHAR_FOR_NEW_LINE = "&#10;";
    private static final String DEFAULT_ERROR_MESSAGE = "Unspecified failure";
    private static final Optional<DateTime> NO_TIMESTAMP = Optional.absent();

    public boolean canConvert(Class clazz) {
        return TestOutcome.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        TestOutcome testOutcome = (TestOutcome)value;
        Preconditions.checkNotNull((Object)testOutcome, (Object)"The test run was null - WTF?");
        writer.addAttribute(TITLE_FIELD, this.escape(this.titleFrom(testOutcome)));
        writer.addAttribute("name", this.nameFrom(testOutcome));
        if (testOutcome.getQualifier() != null && testOutcome.getQualifier().isPresent()) {
            writer.addAttribute(QUALIFIER_FIELD, this.escape((String)testOutcome.getQualifier().get()));
        }
        writer.addAttribute(STEPS_FIELD, Integer.toString(testOutcome.countTestSteps()));
        writer.addAttribute(SUCCESSFUL_FIELD, Integer.toString(testOutcome.getSuccessCount()));
        writer.addAttribute(FAILURES_FIELD, Integer.toString(testOutcome.getFailureCount()));
        if (testOutcome.getErrorCount() > 0) {
            writer.addAttribute(ERRORS_FIELD, Integer.toString(testOutcome.getErrorCount()));
        }
        writer.addAttribute(SKIPPED_FIELD, Integer.toString(testOutcome.getSkippedCount()));
        writer.addAttribute(IGNORED_FIELD, Integer.toString(testOutcome.getIgnoredCount()));
        writer.addAttribute(PENDING_FIELD, Integer.toString(testOutcome.getPendingCount()));
        writer.addAttribute(RESULT_FIELD, testOutcome.getResult().name());
        writer.addAttribute(DURATION, Long.toString(testOutcome.getDuration()));
        writer.addAttribute(TIMESTAMP, this.formattedTimestamp(testOutcome.getStartTime()));
        if (StringUtils.isNotEmpty((CharSequence)testOutcome.getSessionId())) {
            writer.addAttribute(SESSION_ID, testOutcome.getSessionId());
        }
        this.addUserStoryTo(writer, testOutcome.getUserStory());
        this.addIssuesTo(writer, testOutcome.getIssues());
        this.addTagsTo(writer, testOutcome.getTags());
        this.addExamplesTo(writer, testOutcome.getDataTable());
        List<TestStep> steps = testOutcome.getTestSteps();
        for (TestStep step : steps) {
            this.writeStepTo(writer, step);
        }
    }

    private String formattedTimestamp(DateTime startTime) {
        return startTime.toString();
    }

    private String escape(String attribute) {
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            attribute = StringUtils.replace((String)attribute, (String)NEW_LINE_CHAR, (String)ESCAPE_CHAR_FOR_NEW_LINE);
        }
        return attribute;
    }

    private String unescape(String attribute) {
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            attribute = StringUtils.replace((String)attribute, (String)ESCAPE_CHAR_FOR_NEW_LINE, (String)NEW_LINE_CHAR);
        }
        return attribute;
    }

    private String titleFrom(TestOutcome testOutcome) {
        return testOutcome.getTitle();
    }

    private String nameFrom(TestOutcome testOutcome) {
        if (testOutcome.getMethodName() != null) {
            return testOutcome.getMethodName();
        }
        return testOutcome.getTitle();
    }

    private void writeStepTo(HierarchicalStreamWriter writer, TestStep step) {
        if (step.isAGroup()) {
            writer.startNode(TEST_GROUP);
            writer.addAttribute("name", step.getDescription());
            this.writeResult(writer, step);
            this.writeScreenshotIfPresent(writer, step);
            List<TestStep> nestedSteps = step.getChildren();
            for (TestStep nestedStep : nestedSteps) {
                this.writeStepTo(writer, nestedStep);
            }
            writer.endNode();
        } else {
            writer.startNode(TEST_STEP);
            this.writeResult(writer, step);
            writer.addAttribute(DURATION, Long.toString(step.getDuration()));
            this.writeScreenshotIfPresent(writer, step);
            this.writeDescription(writer, step);
            this.writeErrorForFailingTest(writer, step);
            writer.endNode();
        }
    }

    private void addUserStoryTo(HierarchicalStreamWriter writer, Story userStory) {
        if (userStory != null) {
            writer.startNode(USER_STORY);
            writer.addAttribute(ID_FIELD, userStory.getId());
            writer.addAttribute("name", userStory.getName());
            if (userStory.getPath() != null) {
                writer.addAttribute(PATH_FIELD, userStory.getPath());
            }
            if (userStory.getFeatureClass() != null) {
                this.writeFeatureNode(writer, userStory);
            }
            writer.endNode();
        }
    }

    private void writeFeatureNode(HierarchicalStreamWriter writer, Story userStory) {
        ApplicationFeature feature = ApplicationFeature.from(userStory.getFeatureClass());
        writer.startNode(FEATURE);
        writer.addAttribute(ID_FIELD, feature.getId());
        writer.addAttribute("name", feature.getName());
        writer.endNode();
    }

    private void addIssuesTo(HierarchicalStreamWriter writer, Set<String> issues) {
        if (!issues.isEmpty()) {
            writer.startNode(ISSUES);
            for (String issue : issues) {
                writer.startNode(ISSUE);
                writer.setValue(issue);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void addTagsTo(HierarchicalStreamWriter writer, Set<TestTag> tags) {
        if (!CollectionUtils.isEmpty(tags)) {
            writer.startNode(TAGS);
            for (TestTag tag : tags) {
                writer.startNode(TAG);
                writer.addAttribute("name", tag.getName());
                writer.addAttribute(TAG_TYPE, tag.getType());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void addExamplesTo(HierarchicalStreamWriter writer, DataTable dataTable) {
        if (dataTable != null && !dataTable.getRows().isEmpty()) {
            writer.startNode(EXAMPLES);
            this.writeHeaders(writer, dataTable);
            this.writeRows(writer, dataTable);
            writer.endNode();
        }
    }

    private void writeHeaders(HierarchicalStreamWriter writer, DataTable dataTable) {
        writer.startNode(HEADERS);
        for (String header : dataTable.getHeaders()) {
            this.writeHeader(writer, header);
        }
        writer.endNode();
    }

    private void writeRows(HierarchicalStreamWriter writer, DataTable dataTable) {
        writer.startNode(ROWS);
        for (DataTableRow rowData : dataTable.getRows()) {
            this.writeRow(writer, rowData);
        }
        writer.endNode();
    }

    private void writeRow(HierarchicalStreamWriter writer, DataTableRow rowData) {
        writer.startNode(ROW);
        if (rowData.getResult() != TestResult.UNDEFINED) {
            writer.addAttribute(RESULT_FIELD, rowData.getResult().toString());
        }
        for (Object cellValue : rowData.getValues()) {
            this.writeCellValue(writer, cellValue.toString());
        }
        writer.endNode();
    }

    private void writeHeader(HierarchicalStreamWriter writer, String header) {
        writer.startNode(HEADER);
        writer.setValue(header);
        writer.endNode();
    }

    private void writeCellValue(HierarchicalStreamWriter writer, String cellValue) {
        writer.startNode(VALUE);
        writer.setValue(cellValue);
        writer.endNode();
    }

    private void writeErrorForFailingTest(HierarchicalStreamWriter writer, TestStep step) {
        if (step.isFailure().booleanValue() || step.isError().booleanValue()) {
            this.writeErrorMessageAndException(writer, step);
        }
    }

    private void writeErrorMessageAndException(HierarchicalStreamWriter writer, TestStep step) {
        String errorMessage = StringUtils.isEmpty((CharSequence)step.getErrorMessage()) ? DEFAULT_ERROR_MESSAGE : step.getErrorMessage();
        this.writeErrorMessageNode(writer, errorMessage);
        if (step.getException() != null) {
            this.writeExceptionNode(writer, step.getException());
        }
    }

    private void writeExceptionNode(HierarchicalStreamWriter writer, Throwable cause) {
        writer.startNode(EXCEPTION);
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stringWriter));
        writer.setValue(stringWriter.toString());
        writer.endNode();
    }

    private void writeErrorMessageNode(HierarchicalStreamWriter writer, String errorMessage) {
        writer.startNode(ERROR);
        writer.setValue(errorMessage);
        writer.endNode();
    }

    private void writeScreenshotIfPresent(HierarchicalStreamWriter writer, TestStep step) {
        if (step.getScreenshots() != null && step.getScreenshots().size() > 0) {
            writer.startNode(SCREENSHOT_LIST_FIELD);
            for (ScreenshotAndHtmlSource screenshotAndHtmlSource : step.getScreenshots()) {
                writer.startNode(SCREENSHOT_FIELD);
                writer.addAttribute(SCREENSHOT_IMAGE, screenshotAndHtmlSource.getScreenshotFile().getName());
                if (screenshotAndHtmlSource.getSourcecode().isPresent()) {
                    writer.addAttribute(SCREENSHOT_SOURCE, ((File)screenshotAndHtmlSource.getSourcecode().get()).getName());
                }
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeResult(HierarchicalStreamWriter writer, TestStep step) {
        writer.addAttribute(RESULT_FIELD, step.getResult().toString());
    }

    private void writeDescription(HierarchicalStreamWriter writer, TestStep step) {
        writer.startNode(DESCRIPTION);
        writer.setValue(step.getDescription());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String methodName = reader.getAttribute("name");
        TestOutcome testOutcome = new TestOutcome(methodName);
        testOutcome.setTitle(this.unescape(reader.getAttribute(TITLE_FIELD)));
        TestResult savedTestResult = TestResult.valueOf(reader.getAttribute(RESULT_FIELD));
        if (reader.getAttribute(QUALIFIER_FIELD) != null) {
            testOutcome = testOutcome.withQualifier(this.unescape(reader.getAttribute(QUALIFIER_FIELD)));
        }
        Long duration = this.readDuration(reader);
        testOutcome.setDuration(duration);
        Optional<DateTime> startTime = this.readTimestamp(reader);
        if (startTime.isPresent()) {
            testOutcome.setStartTime((DateTime)startTime.get());
        }
        String sessionId = this.readSessionId(reader);
        testOutcome.setSessionId(sessionId);
        this.readChildren(reader, testOutcome);
        if (testOutcome.getStepCount().equals(0)) {
            testOutcome.setAnnotatedResult(savedTestResult);
        }
        return testOutcome;
    }

    private void readChildren(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(TEST_STEP)) {
                this.readTestStep(reader, testOutcome);
            } else if (childNode.equals(TEST_GROUP)) {
                this.readTestGroup(reader, testOutcome);
            } else if (childNode.equals(ISSUES)) {
                this.readTestRunIssues(reader, testOutcome);
            } else if (childNode.equals(USER_STORY)) {
                this.readUserStory(reader, testOutcome);
            } else if (childNode.equals(TAGS)) {
                this.readTags(reader, testOutcome);
            } else if (childNode.equals(EXAMPLES)) {
                this.readExamples(reader, testOutcome);
            }
            reader.moveUp();
        }
    }

    private void readUserStory(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        String storyId = reader.getAttribute(ID_FIELD);
        String storyName = reader.getAttribute("name");
        String storyPath = reader.getAttribute(PATH_FIELD);
        ApplicationFeature feature = null;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(FEATURE)) {
                feature = this.readFeature(reader);
            }
            reader.moveUp();
        }
        Story story = feature == null ? Story.withIdAndPath(storyId, storyName, storyPath) : Story.withId(storyId, storyName, feature.getId(), feature.getName());
        testOutcome.setUserStory(story);
    }

    private ApplicationFeature readFeature(HierarchicalStreamReader reader) {
        String featureId = reader.getAttribute(ID_FIELD);
        String featureName = reader.getAttribute("name");
        return new ApplicationFeature(featureId, featureName);
    }

    private void readTestRunIssues(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String issue = reader.getValue();
            testOutcome.isRelatedToIssue(issue);
            reader.moveUp();
        }
    }

    private void readTags(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(TAG)) {
                tags.add(this.readTag(reader));
            }
            reader.moveUp();
        }
        testOutcome.setTags(tags);
    }

    private void readExamples(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        List<Object> headers = Lists.newArrayList();
        List<Object> rows = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(HEADERS)) {
                headers = this.readHeaders(reader);
            } else if (childNode.equals(ROWS)) {
                rows = this.readRows(reader);
            }
            reader.moveUp();
        }
        DataTable table = DataTable.withHeaders(headers).andRowData(rows).build();
        testOutcome.useExamplesFrom(table);
    }

    private List<String> readHeaders(HierarchicalStreamReader reader) {
        ArrayList headers = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(HEADER)) {
                headers.add(reader.getValue());
            }
            reader.moveUp();
        }
        return headers;
    }

    private List<DataTableRow> readRows(HierarchicalStreamReader reader) {
        ArrayList rows = Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(ROW)) {
                rows.add(this.readRow(reader));
            }
            reader.moveUp();
        }
        return rows;
    }

    private DataTableRow readRow(HierarchicalStreamReader reader) {
        ArrayList rowValues = Lists.newArrayList();
        TestResult result = null;
        String resultValue = reader.getAttribute(RESULT_FIELD);
        while (reader.hasMoreChildren()) {
            result = resultValue != null ? TestResult.valueOf(resultValue) : TestResult.SUCCESS;
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(VALUE)) {
                rowValues.add(reader.getValue());
            }
            reader.moveUp();
        }
        DataTableRow newRow = new DataTableRow(rowValues);
        if (result != null) {
            newRow.setResult(result);
        }
        return newRow;
    }

    private TestTag readTag(HierarchicalStreamReader reader) {
        return TestTag.withName(reader.getAttribute("name")).andType(reader.getAttribute(TAG_TYPE));
    }

    private void readTestStep(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        TestStep step = new TestStep();
        String testResultValue = reader.getAttribute(RESULT_FIELD);
        TestResult result = TestResult.valueOf(testResultValue);
        step.setResult(result);
        Long duration = this.readDuration(reader);
        step.setDuration(duration);
        this.readTestStepChildren(reader, step);
        testOutcome.recordStep(step);
    }

    private long readDuration(HierarchicalStreamReader reader) {
        String durationValue = reader.getAttribute(DURATION);
        if (StringUtils.isNumeric((CharSequence)durationValue)) {
            return Long.parseLong(reader.getAttribute(DURATION));
        }
        return 0L;
    }

    private Optional<DateTime> readTimestamp(HierarchicalStreamReader reader) {
        String timestamp = reader.getAttribute(TIMESTAMP);
        return timestamp != null ? Optional.of((Object)DateTime.parse((String)reader.getAttribute(TIMESTAMP))) : NO_TIMESTAMP;
    }

    private String readSessionId(HierarchicalStreamReader reader) {
        return reader.getAttribute(SESSION_ID);
    }

    private void readTestGroup(HierarchicalStreamReader reader, TestOutcome testOutcome) {
        String name = reader.getAttribute("name");
        String testResultValue = reader.getAttribute(RESULT_FIELD);
        TestResult result = TestResult.valueOf(testResultValue);
        testOutcome.recordStep(new TestStep(name));
        testOutcome.startGroup();
        testOutcome.getCurrentGroup().setResult(result);
        this.readChildren(reader, testOutcome);
        testOutcome.endGroup();
    }

    private void readTestStepChildren(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(DESCRIPTION)) {
                step.setDescription(reader.getValue());
            } else if (childNode.equals(SCREENSHOT_LIST_FIELD)) {
                this.readScreenshots(reader, step);
            }
            reader.moveUp();
        }
    }

    private void readScreenshots(HierarchicalStreamReader reader, TestStep step) {
        if (reader.getNodeName().equals(SCREENSHOT_LIST_FIELD)) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String childNode = reader.getNodeName();
                if (childNode.equals(SCREENSHOT_FIELD)) {
                    String screenshot = reader.getAttribute(SCREENSHOT_IMAGE);
                    String source = reader.getAttribute(SCREENSHOT_SOURCE);
                    if (source != null) {
                        step.addScreenshot(new ScreenshotAndHtmlSource(new File(screenshot), new File(source)));
                    } else {
                        step.addScreenshot(new ScreenshotAndHtmlSource(new File(screenshot)));
                    }
                }
                reader.moveUp();
            }
        }
    }
}

