/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.util.EnvironmentVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementsOutcomes {
    private final List<RequirementOutcome> requirementOutcomes;
    private final TestOutcomes testOutcomes;
    private final Optional<Requirement> parentRequirement;
    private final EnvironmentVariables environmentVariables;
    private final IssueTracking issueTracking;
    private final List<RequirementsTagProvider> requirementsTagProviders;
    public static final Integer DEFAULT_TESTS_PER_REQUIREMENT = 4;
    List<RequirementOutcome> flattenedRequirementOutcomes = null;

    public RequirementsOutcomes(List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<RequirementsTagProvider> requirementsTagProviders) {
        this(null, requirements, testOutcomes, issueTracking, environmentVariables, requirementsTagProviders);
    }

    public RequirementsOutcomes(Requirement parentRequirement, List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<RequirementsTagProvider> requirementsTagProviders) {
        this.testOutcomes = testOutcomes;
        this.parentRequirement = Optional.fromNullable((Object)parentRequirement);
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.requirementOutcomes = this.buildRequirementOutcomes(requirements, requirementsTagProviders);
    }

    private List<RequirementOutcome> buildRequirementOutcomes(List<Requirement> requirements, List<RequirementsTagProvider> requirementsTagProviders) {
        ArrayList outcomes = Lists.newArrayList();
        System.out.println("BUILDING REQUIREMENTS OUTCOMES: " + requirements);
        for (Requirement requirement : requirements) {
            this.buildRequirements(outcomes, requirementsTagProviders, requirement);
        }
        return outcomes;
    }

    private void buildRequirements(List<RequirementOutcome> outcomes, List<RequirementsTagProvider> requirementsTagProviders, Requirement requirement) {
        System.out.println("PROCESSING " + requirement.getType() + " REQUIREMENT " + requirement.getName());
        TestOutcomes outcomesForRequirement = this.testOutcomes.forRequirement(requirement);
        System.out.println("  - Test outcomes: " + outcomesForRequirement.getTotal());
        int requirementsWithoutTests = this.countRequirementsWithoutTestsIn(requirement);
        int estimatedUnimplementedTests = requirementsWithoutTests * this.estimatedTestsPerRequirement();
        outcomes.add(new RequirementOutcome(requirement, outcomesForRequirement, requirementsWithoutTests, estimatedUnimplementedTests, this.issueTracking));
    }

    private int countRequirementsWithoutTestsIn(Requirement rootRequirement) {
        List<Requirement> flattenedRequirements = this.getFlattenedRequirements(rootRequirement);
        int requirementsWithoutTests = 0;
        for (Requirement requirement : flattenedRequirements) {
            TestOutcomes matchingOutcomes = this.testOutcomes.withTag(requirement.asTag());
            if (matchingOutcomes.getTotal() != 0) continue;
            ++requirementsWithoutTests;
        }
        return requirementsWithoutTests;
    }

    public int getFlattenedRequirementCount() {
        int requirementCount = 0;
        for (RequirementOutcome requirement : this.requirementOutcomes) {
            requirementCount += requirement.getFlattenedRequirementCount();
        }
        return requirementCount;
    }

    private List<Requirement> getFlattenedRequirements(Requirement rootRequirement) {
        ArrayList flattenedRequirements = Lists.newArrayList();
        flattenedRequirements.add(rootRequirement);
        flattenedRequirements.addAll(rootRequirement.getNestedChildren());
        return flattenedRequirements;
    }

    public Optional<Requirement> getParentRequirement() {
        return this.parentRequirement;
    }

    public int getRequirementCount() {
        return this.requirementOutcomes.size();
    }

    public List<RequirementOutcome> getRequirementOutcomes() {
        return ImmutableList.copyOf(this.requirementOutcomes);
    }

    public String getType() {
        if (this.requirementOutcomes.isEmpty()) {
            return "requirement";
        }
        return this.requirementOutcomes.get(0).getRequirement().getType();
    }

    public String getChildrenType() {
        return this.typeOfFirstChildPresent();
    }

    private String typeOfFirstChildPresent() {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (outcome.getRequirement().getChildren().isEmpty()) continue;
            Requirement firstChildRequirement = outcome.getRequirement().getChildren().get(0);
            return firstChildRequirement.getType();
        }
        return null;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public String toString() {
        return "RequirementsOutcomes{requirementOutcomes=" + this.requirementOutcomes + ", parentRequirement=" + this.parentRequirement + '}';
    }

    public int getCompletedRequirementsCount() {
        int completedRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isComplete()) continue;
            ++completedRequirements;
        }
        return completedRequirements;
    }

    public int getFailingRequirementsCount() {
        int failingRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isFailure()) continue;
            ++failingRequirements;
        }
        return failingRequirements;
    }

    public int getPendingRequirementsCount() {
        int total = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isPending()) continue;
            ++total;
        }
        return total;
    }

    public int getRequirementsWithoutTestsCount() {
        int requirementsWithNoTests = 0;
        List<RequirementOutcome> flattenedRequirementOutcomes = this.getFlattenedRequirementOutcomes();
        for (Requirement requirement : this.getAllRequirements()) {
            if (this.testsRecordedFor(flattenedRequirementOutcomes, requirement)) continue;
            ++requirementsWithNoTests;
        }
        return requirementsWithNoTests;
    }

    private boolean testsRecordedFor(List<RequirementOutcome> outcomes, Requirement requirement) {
        for (RequirementOutcome outcome : outcomes) {
            if (!outcome.testsRequirement(requirement) || outcome.getTestCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Requirement> getAllRequirements() {
        ArrayList allRequirements = Lists.newArrayList();
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            this.addFlattenedRequirements(outcome.getRequirement(), allRequirements);
        }
        return ImmutableList.copyOf((Collection)allRequirements);
    }

    private void addFlattenedRequirements(Requirement requirement, List<Requirement> allRequirements) {
        allRequirements.add(requirement);
        for (Requirement child : requirement.getChildren()) {
            this.addFlattenedRequirements(child, allRequirements);
        }
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes() {
        if (this.flattenedRequirementOutcomes == null) {
            this.flattenedRequirementOutcomes = this.getFlattenedRequirementOutcomes(this.requirementOutcomes);
        }
        return this.flattenedRequirementOutcomes;
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes(List<RequirementOutcome> outcomes) {
        ArrayList<RequirementOutcome> flattenedOutcomes = new ArrayList<RequirementOutcome>();
        for (RequirementOutcome requirementOutcome : outcomes) {
            flattenedOutcomes.add(requirementOutcome);
            Requirement requirement = requirementOutcome.getRequirement();
            if (!requirement.hasChildren()) continue;
            for (Requirement childRequirement : requirement.getChildren()) {
                TestOutcomes testOutcomesForChildRequirement = requirementOutcome.getTestOutcomes().withTag(childRequirement.getName());
                List<Requirement> childRequirements = childRequirement.getChildren();
                RequirementsOutcomes childOutcomes = new RequirementsOutcomes(childRequirement, childRequirements, testOutcomesForChildRequirement, this.issueTracking, this.environmentVariables, this.requirementsTagProviders);
                flattenedOutcomes.addAll(this.getFlattenedRequirementOutcomes(childOutcomes.getRequirementOutcomes()));
            }
        }
        return ImmutableList.copyOf(flattenedOutcomes);
    }

    public int getFailingTestCount() {
        return this.testOutcomes.getFailureCount();
    }

    public int getErrorTestCount() {
        return this.testOutcomes.getErrorCount();
    }

    public int getPassingTestCount() {
        return this.testOutcomes.getSuccessCount();
    }

    public int getTotalTestCount() {
        return this.testOutcomes.getTotal();
    }

    public int getPendingTestCount() {
        return this.testOutcomes.getPendingCount();
    }

    public int getSkippedTestCount() {
        return this.testOutcomes.getSkipCount();
    }

    public double getPercentagePassingTestCount() {
        return (double)this.getPassingTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public double getPercentageFailingTestCount() {
        return (double)this.getFailingTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public double getPercentageErrorTestCount() {
        return (double)this.getErrorTestCount() / (double)this.totalEstimatedAndImplementedTests();
    }

    public double getPercentagePendingTestCount() {
        return 1.0 - this.getPercentageFailingTestCount() - this.getPercentagePassingTestCount() - this.getPercentageErrorTestCount();
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentagePassingTestCount(), this.getPercentagePendingTestCount(), this.getPercentageFailingTestCount(), this.getPercentageErrorTestCount());
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.getTotalTestCount();
        return totalImplementedTests + this.getEstimatedUnimplementedTests();
    }

    public int getEstimatedUnimplementedTests() {
        return this.getRequirementsWithoutTestsCount() * this.estimatedTestsPerRequirement();
    }

    private int estimatedTestsPerRequirement() {
        return this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.ESTIMATED_TESTS_PER_REQUIREMENT.toString(), DEFAULT_TESTS_PER_REQUIREMENT);
    }
}

