/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.LocalPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileLocalPreferences
implements LocalPreferences {
    private File workingDirectory;
    private File homeDirectory;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileLocalPreferences.class);

    @Inject
    public PropertiesFileLocalPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.homeDirectory = new File(System.getProperty("user.home"));
        this.workingDirectory = new File(System.getProperty("user.dir"));
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public void loadPreferences() throws IOException {
        this.updatePreferencesFrom(this.preferencesFileInHomeDirectory());
        this.updatePreferencesFrom(this.preferencesFileInWorkingDirectory());
        this.updatePreferencesFrom(this.preferencesFileWithAbsolutePath());
        this.updatePreferencesFromClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreferencesFromClasspath() throws IOException {
        InputStream propertiesOnClasspath = null;
        try {
            propertiesOnClasspath = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.defaultPropertiesFileName());
            if (propertiesOnClasspath != null) {
                Properties localPreferences = new Properties();
                localPreferences.load(propertiesOnClasspath);
                this.setUndefinedSystemPropertiesFrom(localPreferences);
            }
        }
        finally {
            if (propertiesOnClasspath != null) {
                propertiesOnClasspath.close();
            }
        }
    }

    private void updatePreferencesFrom(File preferencesFile) throws IOException {
        LOGGER.info("LOADING LOCAL THUCYDIDES PROPERTIES FROM {} ", (Object)preferencesFile.getAbsolutePath());
        if (preferencesFile.exists()) {
            Properties localPreferences = new Properties();
            localPreferences.load(new FileInputStream(preferencesFile));
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private void setUndefinedSystemPropertiesFrom(Properties localPreferences) {
        Enumeration<?> propertyNames = localPreferences.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String localPropertyValue = localPreferences.getProperty(propertyName);
            String currentPropertyValue = this.environmentVariables.getProperty(propertyName);
            if (currentPropertyValue != null || localPropertyValue == null) continue;
            LOGGER.info(propertyName + "=" + localPropertyValue);
            this.environmentVariables.setProperty(propertyName, localPropertyValue);
        }
    }

    private File preferencesFileInHomeDirectory() {
        return new File(this.homeDirectory, this.defaultPropertiesFileName());
    }

    private File preferencesFileInWorkingDirectory() {
        return new File(this.workingDirectory, this.defaultPropertiesFileName());
    }

    private File preferencesFileWithAbsolutePath() {
        return new File(this.defaultPropertiesFileName());
    }

    private String defaultPropertiesFileName() {
        return ThucydidesSystemProperty.PROPERTIES.from(this.environmentVariables, "thucydides.properties");
    }
}

