/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Optional;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.NameConverter;

public class ReportNameProvider {
    private final Optional<String> context;
    private final ReportNamer reportNamer;
    private static final Optional<String> NO_CONTEXT = Optional.absent();

    public ReportNameProvider() {
        this(NO_CONTEXT, ReportType.HTML);
    }

    public ReportNameProvider(String context) {
        this((Optional<String>)Optional.fromNullable((Object)context), ReportType.HTML);
    }

    protected ReportNameProvider(Optional<String> context, ReportType type) {
        this.context = context;
        this.reportNamer = ReportNamer.forReportType(type);
    }

    public ReportNameProvider forCSVFiles() {
        return new ReportNameProvider(this.context, ReportType.CSV);
    }

    public String forTestResult(String result) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "result_" + result);
    }

    public String forTag(String tag) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tag_" + tag);
    }

    public String forTagType(String tagType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tagtype_" + tagType);
    }

    public ReportNameProvider withPrefix(String prefix) {
        return new ReportNameProvider(prefix);
    }

    private String prefixUsing(Optional<String> context) {
        if (context.isPresent()) {
            return "context_" + NameConverter.underscore((String)context.get()) + "_";
        }
        return "";
    }

    public String forRequirement(Requirement parentRequirement) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "requirement_" + parentRequirement.getName());
    }
}

