/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.DatabaseConfig;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.statistics.dao.TestOutcomeHistoryDAO;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;

public class StatisticsListener
implements StepListener {
    private final TestOutcomeHistoryDAO testOutcomeHistoryDAO;
    private final EnvironmentVariables environmentVariables;
    private final List<TestOutcome> testOutcomes;
    private final DatabaseConfig databaseConfig;

    @Inject
    public StatisticsListener(TestOutcomeHistoryDAO testOutcomeHistoryDAO, EnvironmentVariables environmentVariables, DatabaseConfig databaseConfig) {
        this.testOutcomeHistoryDAO = testOutcomeHistoryDAO;
        this.environmentVariables = environmentVariables;
        this.databaseConfig = databaseConfig;
        this.testOutcomes = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void testSuiteStarted(Class<?> storyClass) {
    }

    @Override
    public void testSuiteStarted(Story story) {
    }

    @Override
    public void testStarted(String description) {
    }

    @Override
    public void testFinished(TestOutcome result) {
        if (this.historyActivated() && !this.testOutcomes.contains(result)) {
            this.testOutcomes.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testSuiteFinished() {
        if (this.historyActivated()) {
            List<TestOutcome> list = this.testOutcomes;
            synchronized (list) {
                this.storePending(this.testOutcomes);
            }
        }
    }

    private void storePending(List<TestOutcome> testOutcomes) {
        ImmutableList outcomesReadyToBeStored = ImmutableList.copyOf(testOutcomes);
        this.testOutcomeHistoryDAO.storeTestOutcomes((List<TestOutcome>)outcomesReadyToBeStored);
        testOutcomes.removeAll((Collection<?>)outcomesReadyToBeStored);
    }

    private boolean historyActivated() {
        return this.databaseConfig.isActive() && this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.RECORD_STATISTICS.getPropertyName(), true) != false;
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    @Override
    public void stepFailed(StepFailure failure) {
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
    }

    @Override
    public void stepIgnored() {
    }

    public void stepIgnored(String message) {
    }

    @Override
    public void stepPending() {
    }

    @Override
    public void stepPending(String message) {
    }

    @Override
    public void stepFinished() {
    }

    @Override
    public void testFailed(TestOutcome result, Throwable cause) {
    }

    @Override
    public void testIgnored() {
    }

    @Override
    public void notifyScreenChange() {
    }

    @Override
    public void useExamplesFrom(DataTable table) {
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
    }

    @Override
    public void exampleFinished() {
    }

    @Override
    public void assumptionViolated(String message) {
    }
}

