/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepProvider;
import net.thucydides.core.steps.ScenarioSteps;

public abstract class StepIndex {
    public List<Class<? extends ScenarioSteps>> getStepClasses() {
        List<Class<? extends ScenarioSteps>> stepProviders;
        Field stepProviderField = this.getStepProviderField();
        try {
            Class[] providerFieldValue = (Class[])stepProviderField.get(this);
            stepProviders = this.getStepProvidersFrom(providerFieldValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("No step provider field found.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No step provider field found.", e);
        }
        return stepProviders;
    }

    public List<Method> getStepsFor(Class<? extends ScenarioSteps> scenarioClass) {
        Method[] methods;
        ArrayList<Method> steps = new ArrayList<Method>();
        for (Method method : methods = scenarioClass.getMethods()) {
            if (!method.isAnnotationPresent(Step.class)) continue;
            steps.add(method);
        }
        return steps;
    }

    private List<Class<? extends ScenarioSteps>> getStepProvidersFrom(Class<?>[] providerFieldValue) {
        ArrayList<Class<? extends ScenarioSteps>> stepProviders = new ArrayList<Class<? extends ScenarioSteps>>();
        for (Class<?> providerClass : providerFieldValue) {
            if (!ScenarioSteps.class.isAssignableFrom(providerClass)) {
                throw new IllegalArgumentException(providerClass + " needs to extend ScenarioSteps");
            }
            stepProviders.add(providerClass);
        }
        return stepProviders;
    }

    private Field getStepProviderField() {
        for (Field field : Fields.of(this.getClass()).allFields()) {
            if (!field.isAnnotationPresent(StepProvider.class)) continue;
            return field;
        }
        throw new IllegalArgumentException("No step provider field found.");
    }
}

