/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.matchers;

import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestOutcomeMatchers {
    public static Matcher<TestOutcome> havingTagType(final String tagType) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                for (TestTag tag : testOutcome.getTags()) {
                    if (!tag.getType().equals(tagType)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag of type ").appendValue((Object)tagType);
            }
        };
    }

    public static Matcher<TestOutcome> havingTagName(final String tagName) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                for (TestTag tag : testOutcome.getTags()) {
                    if (!tag.getName().equalsIgnoreCase(tagName)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag ").appendValue((Object)tagName);
            }
        };
    }

    public static Matcher<TestOutcome> havingTag(final TestTag expectedTag) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                for (TestTag tag : testOutcome.getTags()) {
                    if (!tag.equals(expectedTag)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag ").appendValue((Object)expectedTag);
            }
        };
    }

    public static Matcher<TestOutcome> withResult(final TestResult testResult) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                return testOutcome.getResult().equals((Object)testResult);
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a result of ").appendValue((Object)testResult);
            }
        };
    }
}

