/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementsOutcomes {
    private final List<RequirementOutcome> requirementOutcomes;
    private final TestOutcomes testOutcomes;
    private final Optional<Requirement> parentRequirement;

    public RequirementsOutcomes(List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this(null, requirements, testOutcomes, issueTracking);
    }

    public RequirementsOutcomes(Requirement parentRequirement, List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this.testOutcomes = testOutcomes;
        this.parentRequirement = Optional.fromNullable((Object)parentRequirement);
        ArrayList outcomes = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            TestOutcomes outcomesForRequirement = testOutcomes.withTag(requirement.getName());
            outcomes.add(new RequirementOutcome(requirement, outcomesForRequirement, issueTracking));
        }
        this.requirementOutcomes = outcomes;
    }

    public Optional<Requirement> getParentRequirement() {
        return this.parentRequirement;
    }

    public int getRequirementCount() {
        return this.requirementOutcomes.size();
    }

    public List<RequirementOutcome> getRequirementOutcomes() {
        return ImmutableList.copyOf(this.requirementOutcomes);
    }

    public String getType() {
        if (this.requirementOutcomes.isEmpty()) {
            return "requirement";
        }
        return this.requirementOutcomes.get(0).getRequirement().getType();
    }

    public String getChildrenType() {
        return this.typeOfFirstChildPresent();
    }

    private String typeOfFirstChildPresent() {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (outcome.getRequirement().getChildren().isEmpty()) continue;
            Requirement firstChildRequirement = outcome.getRequirement().getChildren().get(0);
            return firstChildRequirement.getType();
        }
        return null;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("requirements(\n");
        for (RequirementOutcome requirement : this.getRequirementOutcomes()) {
            builder.append("  requirement(name=" + requirement.getRequirement().getName() + ", card=" + requirement.getRequirement().getCardNumber() + ", type=" + requirement.getRequirement().getType() + ", narrative=" + requirement.getRequirement().getNarrativeText() + ")");
        }
        builder.append(")");
        return "RequirementsOutcomes{requirementOutcomes=" + this.requirementOutcomes + ", parentRequirement=" + this.parentRequirement + '}';
    }
}

