/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.csv.FailedToInitializeTestData;
import net.thucydides.core.csv.FieldName;
import net.thucydides.core.csv.InstanceBuilder;
import net.thucydides.core.csv.TestDataSource;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVTestDataSource
implements TestDataSource {
    private final List<Map<String, String>> testData;
    private final char separator;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVTestDataSource.class);

    public CSVTestDataSource(String path, char separatorValue) throws IOException {
        this.separator = separatorValue;
        this.testData = this.loadTestDataFrom(this.getDataFileFor(path));
    }

    public CSVTestDataSource(String path) throws IOException {
        this(path, ',');
    }

    public static boolean validTestDataPath(String path) {
        if (CSVTestDataSource.validFileSystemPath(path)) {
            return true;
        }
        URL testDataUrl = CSVTestDataSource.class.getClassLoader().getResource(path);
        return testDataUrl != null && new File(testDataUrl.getFile()).exists();
    }

    private Reader getDataFileFor(String path) throws FileNotFoundException {
        if (CSVTestDataSource.isAClasspathResource(path)) {
            try {
                return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path));
            }
            catch (Throwable e) {
                LOGGER.error(e.getMessage(), e);
                throw new FileNotFoundException("Could not load test data from " + path);
            }
        }
        return new FileReader(new File(path));
    }

    private static boolean isAClasspathResource(String path) {
        return !CSVTestDataSource.validFileSystemPath(path);
    }

    private static boolean validFileSystemPath(String path) {
        File file = new File(path);
        return file.exists();
    }

    protected List<Map<String, String>> loadTestDataFrom(Reader testDataReader) throws IOException {
        CSVReader reader = new CSVReader(testDataReader, this.separator);
        List rows = reader.readAll();
        ArrayList<Map<String, String>> loadedData = new ArrayList<Map<String, String>>();
        String[] titleRow = (String[])rows.get(0);
        for (int i = 1; i < rows.size(); ++i) {
            String[] dataRow = (String[])rows.get(i);
            loadedData.add(this.dataEntryFrom(titleRow, dataRow));
        }
        return loadedData;
    }

    private Map<String, String> dataEntryFrom(String[] titleRow, String[] dataRow) {
        HashMap<String, String> dataset = new HashMap<String, String>();
        for (int column = 0; column < titleRow.length; ++column) {
            if (column >= dataRow.length) continue;
            String title = titleRow[column].trim();
            String value = dataRow[column].trim();
            dataset.put(title, value);
        }
        return dataset;
    }

    @Override
    public List<Map<String, String>> getData() {
        return this.testData;
    }

    @Override
    public <T> List<T> getDataAsInstancesOf(Class<T> clazz, Object ... constructorArgs) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, rowData, constructorArgs));
        }
        return resultsList;
    }

    @Override
    public <T extends ScenarioSteps> List<T> getInstanciatedInstancesFrom(Class<T> clazz, StepFactory factory) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, factory, rowData));
        }
        return resultsList;
    }

    private <T> T newInstanceFrom(Class<T> clazz, Map<String, String> rowData, Object ... constructorArgs) {
        T newObject = this.createNewInstanceOf(clazz, constructorArgs);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T extends ScenarioSteps> T newInstanceFrom(Class<T> clazz, StepFactory factory, Map<String, String> rowData) {
        ScenarioSteps newObject = (ScenarioSteps)factory.getUniqueStepLibraryFor(clazz);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return (T)newObject;
    }

    private <T> void assignPropertiesFromTestData(Class<T> clazz, Map<String, String> rowData, T newObject) {
        Set<String> propertyNames = rowData.keySet();
        boolean validPropertyFound = false;
        for (String columnHeading : propertyNames) {
            String value = rowData.get(columnHeading);
            String property = FieldName.from(columnHeading).inNormalizedForm();
            if (!this.assignPropertyValue(newObject, property, value)) continue;
            validPropertyFound = true;
        }
        if (!validPropertyFound) {
            throw new FailedToInitializeTestData("No properties or public fields matching the data columns were found or could be assigned for the class " + clazz.getName() + "using test data: " + rowData);
        }
    }

    protected <T> T createNewInstanceOf(Class<T> clazz, Object ... constructorArgs) {
        try {
            return InstanceBuilder.newInstanceOf(clazz, constructorArgs);
        }
        catch (Exception e) {
            LOGGER.error("Could not create test data bean", (Throwable)e);
            throw new FailedToInitializeTestData("Could not create test data beans", e);
        }
    }

    protected <T> boolean assignPropertyValue(T newObject, String property, String value) {
        boolean valueWasAssigned = true;
        try {
            InstanceBuilder.inObject(newObject).setPropertyValue(property, value);
        }
        catch (FailedToInitializeTestData e) {
            valueWasAssigned = false;
        }
        return valueWasAssigned;
    }
}

