/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.csv.FailedToInitializeTestData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceBuilder {
    private Object targetObject;

    private <T> InstanceBuilder(T newObject) {
        this.targetObject = newObject;
    }

    public static <T> T newInstanceOf(Class<T> clazz, Object ... constructorArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (constructorArgs.length == 0 && InstanceBuilder.thereIsADefaultConstructorFor(clazz)) {
            return clazz.newInstance();
        }
        return InstanceBuilder.invokeConstructorFor(clazz, constructorArgs);
    }

    public static <T> T invokeConstructorFor(Class<T> clazz, Object[] constructorArgs) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != constructorArgs.length) continue;
            return (T)constructor.newInstance(constructorArgs);
        }
        throw new IllegalStateException("No matching constructor found for " + clazz + " with arguments: " + ArrayUtils.toString((Object)constructorArgs));
    }

    private static <T> boolean thereIsADefaultConstructorFor(Class<T> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public void setPropertyValue(String property, String value) {
        if (!this.setProperty(property, value)) {
            throw new FailedToInitializeTestData("Could not find property field " + property);
        }
    }

    private boolean setProperty(String property, String value) {
        try {
            Method setter = this.findSetter(property);
            Field field = this.findField(property);
            if (setter != null) {
                setter.invoke(this.targetObject, value);
                return true;
            }
            if (field != null) {
                field.set(this.targetObject, value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new FailedToInitializeTestData("Could not assign property value", e);
        }
    }

    private Method findSetter(String property) {
        Method[] methods = this.targetObject.getClass().getMethods();
        String setterMethod = "set" + StringUtils.capitalize((String)property);
        for (Method method : methods) {
            if (!method.getName().equals(setterMethod)) continue;
            return method;
        }
        return null;
    }

    private Field findField(String property) {
        List<Field> fields = this.getAllDeclaredFieldsIn(this.targetObject.getClass());
        for (Field field : fields) {
            if (field.getName().compareToIgnoreCase(property) != 0) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private List<Field> getAllDeclaredFieldsIn(Class targetClass) {
        List<Field> parentFields = targetClass.getSuperclass() != null ? this.getAllDeclaredFieldsIn(targetClass.getSuperclass()) : Collections.EMPTY_LIST;
        List<Field> localFields = Arrays.asList(targetClass.getDeclaredFields());
        ArrayList<Field> allFields = new ArrayList<Field>(localFields);
        allFields.addAll(parentFields);
        return allFields;
    }

    public static <T> InstanceBuilder inObject(T newObject) {
        return new InstanceBuilder(newObject);
    }
}

