/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.model.ErrorMessageFormatter;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStep {
    private String description;
    private long duration;
    private long startTime;
    private List<ScreenshotAndHtmlSource> screenshots = new ArrayList<ScreenshotAndHtmlSource>();
    private Throwable cause;
    private TestResult result;
    private List<TestStep> children = new ArrayList<TestStep>();

    public TestStep() {
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        if (!this.hasChildren()) {
            return this.description;
        }
        String childDescriptions = Lambda.join((Object)Lambda.extract(this.children, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
        return this.description + " [" + childDescriptions + "]";
    }

    public TestStep(String description) {
        this();
        this.description = description;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TestStep> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<ScreenshotAndHtmlSource> getScreenshots() {
        return ImmutableList.copyOf(this.screenshots);
    }

    public ScreenshotAndHtmlSource getFirstScreenshot() {
        if (this.screenshots != null && !this.screenshots.isEmpty()) {
            return this.screenshots.get(0);
        }
        return null;
    }

    public boolean needsScreenshots() {
        return !this.isAGroup() && this.getScreenshots() != null;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public TestResult getResult() {
        if (this.isAGroup() && !this.groupResultOverridesChildren()) {
            return this.getResultFromChildren();
        }
        return this.getResultFromThisStep();
    }

    private TestResult getResultFromThisStep() {
        if (this.result != null) {
            return this.result;
        }
        return TestResult.PENDING;
    }

    private boolean groupResultOverridesChildren() {
        return this.result == TestResult.SKIPPED || this.result == TestResult.IGNORED || this.result == TestResult.PENDING;
    }

    private TestResult getResultFromChildren() {
        TestResultList resultList = TestResultList.of(this.getChildResults());
        return resultList.getOverallResult();
    }

    private List<TestResult> getChildResults() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestStep step : this.getChildren()) {
            results.add(step.getResult());
        }
        return results;
    }

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public void failedWith(Throwable exception) {
        this.setResult(TestResult.FAILURE);
        this.cause = exception;
    }

    public String getErrorMessage() {
        return this.cause != null ? this.errorMessageFrom(this.cause) : "";
    }

    public void testAborted(Throwable exception) {
        this.cause = exception;
    }

    private String errorMessageFrom(Throwable error) {
        return error.getCause() != null ? error.getCause().getMessage() : error.getMessage();
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public Throwable getException() {
        return this.cause;
    }

    public List<? extends TestStep> getFlattenedSteps() {
        ArrayList<? extends TestStep> flattenedSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            flattenedSteps.add(child);
            if (!child.isAGroup()) continue;
            flattenedSteps.addAll(child.getFlattenedSteps());
        }
        return flattenedSteps;
    }

    public boolean isAGroup() {
        return this.hasChildren();
    }

    public void addChildStep(TestStep step) {
        this.children.add(step);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Collection<? extends TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            if (child.isAGroup()) {
                leafSteps.addAll(child.getLeafTestSteps());
                continue;
            }
            leafSteps.add(child);
        }
        return leafSteps;
    }

    public void addScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.thisIsANew(screenshotAndHtmlSource)) {
            this.screenshots.add(screenshotAndHtmlSource);
        }
    }

    private boolean thisIsANew(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.screenshots.isEmpty()) {
            return true;
        }
        ScreenshotAndHtmlSource latestScreenshotAndHtmlSource = this.screenshots.get(this.screenshots.size() - 1);
        return !latestScreenshotAndHtmlSource.equals(screenshotAndHtmlSource);
    }

    public int getScreenshotCount() {
        return this.screenshots.size();
    }

    public void removeScreenshot(int index) {
        this.screenshots.remove(index);
    }
}

