/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.dao;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.statistics.dao.TestOutcomeHistoryDAO;
import net.thucydides.core.statistics.model.TestRun;
import net.thucydides.core.statistics.model.TestRunTag;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTestOutcomeHistoryDAO
implements TestOutcomeHistoryDAO {
    private static final String FIND_ALL_TEST_HISTORIES = "select t from TestRun t where t.projectKey = :projectKey order by t.executionDate";
    private static final String FIND_BY_NAME = "select t from TestRun t where t.title = :title and t.projectKey = :projectKey";
    private static final String FIND_TAG_BY_NAME_IGNORING_CASE = "select t from TestRunTag t where lower(t.name) = :name and t.type = :type and t.projectKey = :projectKey";
    private static final String FIND_ALL_TAGS = "select t from TestRunTag t where t.projectKey = :projectKey order by lower(t.name)";
    private static final String FIND_ALL_TAG_TYPES = "select distinct t.type from TestRunTag t where t.projectKey = :projectKey order by t.type";
    private static final String COUNT_BY_NAME = "select count(t) from TestRun t where t.title = :title and t.projectKey = :projectKey";
    private static final String COUNT_TESTS_BY_NAME_AND_RESULT = "select count(t) from TestRun t where t.title = :title and t.projectKey = :projectKey and t.result = :result";
    private static final String COUNT_LATEST_TESTS_BY_TAG_AND_RESULT = "select count(test) from TestRun test  left outer join test.tags as tag where lower(tag.name) = :name and test.result = :result and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String COUNT_LATEST_TESTS_BY_TAG_TYPE_AND_RESULT = "select count(test) from TestRun test  left outer join test.tags as tag where tag.type = :type and test.result = :result and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_LATEST_TEST_BY_TITLE = "select t from TestRun t where t.title = :title and t.projectKey = :projectKey and t.executionDate =      (select max(tt.executionDate) from TestRun tt where tt.id = t.id)";
    private static final String SELECT_LATEST_TEST_BY_TAG = "select test from TestRun test  left outer join test.tags as tag where lower(tag.name) = :name and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_LATEST_TEST_BY_TAG_TYPE = "select test from TestRun test  left outer join test.tags as tag where tag.type = :type and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_TEST_RESULTS_BY_TAG = "select test.result from TestRun test  left outer join test.tags as tag where lower(tag.name) = :name and test.projectKey = :projectKey order by test.executionDate desc";
    private static final String SELECT_TEST_RESULTS_BY_TAG_TYPE = "select test.result from TestRun test  left outer join test.tags as tag where tag.type = :type and test.projectKey = :projectKey order by test.executionDate desc";
    private static final String COUNT_LATEST_TEST_BY_TAG = "select count(test) from TestRun test  left outer join test.tags as tag where lower(tag.name) = :name and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String COUNT_LATEST_TEST_BY_TAG_TYPE = "select count(test) from TestRun test  left outer join test.tags as tag where tag.type = :type and test.projectKey = :projectKey and test.executionDate = (select max(tt.executionDate) from TestRun tt where tt.id = test.id)";
    private static final String SELECT_TEST_RESULTS_BY_TITLE = "select test.result from TestRun test where test.title = :title and test.projectKey = :projectKey order by test.executionDate desc";
    protected EntityManagerFactory entityManagerFactory;
    private final SystemClock clock;
    private final EnvironmentVariables environmentVariables;
    private TagProviderService tagProviderService;
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateTestOutcomeHistoryDAO.class);

    @Inject
    public HibernateTestOutcomeHistoryDAO(EntityManagerFactory entityManagerFactory, EnvironmentVariables environmentVariables, TagProviderService tagProviderService, SystemClock clock) {
        this.entityManagerFactory = entityManagerFactory;
        this.environmentVariables = environmentVariables;
        this.clock = clock;
        this.tagProviderService = tagProviderService;
    }

    @Override
    public List<TestRun> findAll() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(FIND_ALL_TEST_HISTORIES).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    @Override
    public List<TestRun> findTestRunsByTitle(String title) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(FIND_BY_NAME).setParameter("projectKey", (Object)this.getProjectKey()).setParameter("title", (Object)title).getResultList();
    }

    @Override
    public void storeTestOutcomes(List<TestOutcome> testOutcomes) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            this.storeEachOutcomeIn(entityManager, testOutcomes);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
    }

    @Override
    public void storeTestOutcome(TestOutcome testOutcome) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        this.persistTestOutcome(entityManager, testOutcome);
        entityManager.getTransaction().commit();
    }

    private void persistTestOutcome(EntityManager entityManager, TestOutcome testOutcome) {
        TestRun storedHistory = TestRun.from(testOutcome).inProject(this.getProjectKey()).at(this.clock.getCurrentTime().toDate());
        this.addTagsFrom(testOutcome, entityManager).to(storedHistory);
        entityManager.persist((Object)storedHistory);
    }

    private void storeEachOutcomeIn(EntityManager entityManager, List<TestOutcome> testOutcomes) {
        for (TestOutcome testOutcome : testOutcomes) {
            this.persistTestOutcome(entityManager, testOutcome);
        }
    }

    private String getProjectKey() {
        return ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, Thucydides.getDefaultProjectKey());
    }

    private TagAdder addTagsFrom(TestOutcome testResult, EntityManager entityManager) {
        return new TagAdder(testResult, entityManager);
    }

    private List<TestRunTag> findTagsMatching(EntityManager entityManager, TestRunTag tag) {
        return entityManager.createQuery(FIND_TAG_BY_NAME_IGNORING_CASE).setParameter("name", (Object)tag.getName().toLowerCase()).setParameter("type", (Object)tag.getType()).setParameter("projectKey", (Object)tag.getProjectKey()).getResultList();
    }

    @Override
    public List<TestRunTag> findTagsMatching(TestRunTag tag) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return this.findTagsMatching(entityManager, tag);
    }

    @Override
    public void deleteAll() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            List<TestRun> testRuns = this.findAll();
            entityManager.getTransaction().begin();
            for (TestRun testRun : testRuns) {
                entityManager.remove(entityManager.merge((Object)testRun));
            }
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
    }

    @Override
    public Long countTestRunsByTitle(String title) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_BY_NAME).setParameter("title", (Object)title).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public Long countTestRunsByTitleAndResult(String title, TestResult result) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_TESTS_BY_NAME_AND_RESULT).setParameter("title", (Object)title).setParameter("result", (Object)result).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public List<TestRunTag> findAllTags() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(FIND_ALL_TAGS).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    @Override
    public List<TestRunTag> getLatestTagsForTestWithTitleByTitle(String title) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        List latestTestRuns = entityManager.createQuery(SELECT_LATEST_TEST_BY_TITLE).setParameter("title", (Object)title).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    @Override
    public List<TestResult> getResultsTestWithTitle(String title) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(SELECT_TEST_RESULTS_BY_TITLE).setParameter("title", (Object)title).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    @Override
    public List<TestResult> getResultsForTestsWithTag(String tag) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(SELECT_TEST_RESULTS_BY_TAG).setParameter("name", (Object)tag.toLowerCase()).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    @Override
    public List<TestResult> getResultsForTestsWithTagType(String tagType) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(SELECT_TEST_RESULTS_BY_TAG_TYPE).setParameter("type", (Object)tagType).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    @Override
    public Long countTestRunsByTag(String tag) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_LATEST_TEST_BY_TAG).setParameter("name", (Object)tag.toLowerCase()).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public Long countTestRunsByTagType(String tagType) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_LATEST_TEST_BY_TAG_TYPE).setParameter("type", (Object)tagType).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public Long countTestRunsByTagAndResult(String tag, TestResult result) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_LATEST_TESTS_BY_TAG_AND_RESULT).setParameter("name", (Object)tag.toLowerCase()).setParameter("result", (Object)result).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public Long countTestRunsByTagTypeAndResult(String tagType, TestResult result) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return (Long)entityManager.createQuery(COUNT_LATEST_TESTS_BY_TAG_TYPE_AND_RESULT).setParameter("type", (Object)tagType).setParameter("result", (Object)result).setParameter("projectKey", (Object)this.getProjectKey()).getSingleResult();
    }

    @Override
    public List<TestRunTag> getLatestTagsForTestsWithTag(String tag) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        List latestTestRuns = entityManager.createQuery(SELECT_LATEST_TEST_BY_TAG).setParameter("name", (Object)tag.toLowerCase()).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    @Override
    public List<TestRunTag> getLatestTagsForTestsWithTagType(String tagType) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        List latestTestRuns = entityManager.createQuery(SELECT_LATEST_TEST_BY_TAG_TYPE).setParameter("type", (Object)tagType).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
        if (latestTestRuns.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(((TestRun)latestTestRuns.get(0)).getTags());
    }

    @Override
    public List<String> findAllTagTypes() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return entityManager.createQuery(FIND_ALL_TAG_TYPES).setParameter("projectKey", (Object)this.getProjectKey()).getResultList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagAdder {
        private final TestOutcome testOutcome;
        private EntityManager entityManager;

        private TagAdder(TestOutcome testOutcome, EntityManager entityManager) {
            this.testOutcome = testOutcome;
            this.entityManager = entityManager;
        }

        public void to(TestRun storedTestRun) {
            for (TagProvider tagProvider : HibernateTestOutcomeHistoryDAO.this.tagProviderService.getTagProviders()) {
                List tagsToPersist = Lambda.convert(tagProvider.getTagsFor(this.testOutcome), this.toTestRunTags());
                List<TestRunTag> existingTags = this.findAndUpdateAnyExistingTags(storedTestRun, tagsToPersist);
                tagsToPersist.removeAll(existingTags);
                for (TestRunTag tag : tagsToPersist) {
                    this.entityManager.persist((Object)tag);
                    storedTestRun.getTags().add(tag);
                }
            }
        }

        private Converter<TestTag, TestRunTag> toTestRunTags() {
            return new Converter<TestTag, TestRunTag>(){

                public TestRunTag convert(TestTag from) {
                    return new TestRunTag(HibernateTestOutcomeHistoryDAO.this.getProjectKey(), from.getType(), from.getName());
                }
            };
        }

        private List<TestRunTag> findAndUpdateAnyExistingTags(TestRun storedTestRun, List<TestRunTag> tags) {
            ArrayList matchedTags = Lists.newArrayList();
            for (TestRunTag tag : tags) {
                Optional<TestRunTag> matchingStoredTag = this.tagInDatabaseWithIdenticalNameAs(tag);
                if (!matchingStoredTag.isPresent()) continue;
                TestRunTag matchingTag = (TestRunTag)matchingStoredTag.get();
                storedTestRun.getTags().add(matchingTag);
                matchingTag.getTestRuns().add(storedTestRun);
                matchedTags.add(tag);
            }
            return ImmutableList.copyOf((Collection)matchedTags);
        }

        private Optional<TestRunTag> tagInDatabaseWithIdenticalNameAs(TestRunTag tag) {
            List matchingStoredTags = HibernateTestOutcomeHistoryDAO.this.findTagsMatching(this.entityManager, tag);
            if (matchingStoredTags.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(matchingStoredTags.get(0));
        }
    }
}

