/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.database;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class LocalH2ServerDatabase
implements LocalDatabase {
    private final EnvironmentVariables environmentVariables;

    @Inject
    public LocalH2ServerDatabase(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isAvailable() {
        return true;
    }

    public String getUrl() {
        return "jdbc:h2:/" + this.getDatabasePath() + ";AUTO_SERVER=TRUE";
    }

    public String getDriver() {
        return "org.h2.Driver";
    }

    public String getUsername() {
        return "SA";
    }

    public String getPassword() {
        return "";
    }

    public String getDialect() {
        return "org.hibernate.dialect.H2Dialect";
    }

    public String getDatabaseName() {
        String projectKey = ThucydidesSystemProperty.PROJECT_KEY.from(this.environmentVariables, Thucydides.getDefaultProjectKey());
        return StringUtils.join((Iterable)ImmutableList.of((Object)"stats", (Object)projectKey), (String)"-");
    }

    public String getDatabasePath() {
        String defaultThucydidesDirectory = this.environmentVariables.getProperty("user.home") + "/.thucydides";
        String thucydidesHomeDirectory = ThucydidesSystemProperty.THUCYDIDES_HOME.from(this.environmentVariables, defaultThucydidesDirectory);
        return thucydidesHomeDirectory + "/" + this.getDatabaseName();
    }
}

