/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.LocalPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileLocalPreferences
implements LocalPreferences {
    private File workingDirectory;
    private File homeDirectory;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileLocalPreferences.class);

    @Inject
    public PropertiesFileLocalPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.homeDirectory = new File(System.getProperty("user.home"));
        this.workingDirectory = new File(System.getProperty("user.dir"));
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public void loadPreferences() throws IOException {
        File homeDirectoryPreferencesFile = this.getLocalPreferencesFile();
        File workingDirectoryPreferencesFile = this.getLocalWorkingPreferencesFile();
        this.updatePreferencesFromClasspath();
        this.updatePreferencesFrom(workingDirectoryPreferencesFile);
        this.updatePreferencesFrom(homeDirectoryPreferencesFile);
    }

    private void updatePreferencesFromClasspath() throws IOException {
        InputStream propertiesOnClasspath = this.getClass().getClassLoader().getResourceAsStream("/thucydides.properties");
        if (propertiesOnClasspath != null) {
            Properties localPreferences = new Properties();
            localPreferences.load(propertiesOnClasspath);
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private void updatePreferencesFrom(File preferencesFile) throws IOException {
        LOGGER.debug("Loading local Thucydides properties from " + preferencesFile.getAbsolutePath());
        if (preferencesFile.exists()) {
            Properties localPreferences = new Properties();
            localPreferences.load(new FileInputStream(preferencesFile));
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private void setUndefinedSystemPropertiesFrom(Properties localPreferences) {
        for (ThucydidesSystemProperty thucydidesProperty : ThucydidesSystemProperty.values()) {
            String propertyName = thucydidesProperty.getPropertyName();
            String localPropertyValue = localPreferences.getProperty(propertyName);
            String currentPropertyValue = this.environmentVariables.getProperty(propertyName);
            if (currentPropertyValue != null || localPropertyValue == null) continue;
            LOGGER.debug(propertyName + "=" + localPropertyValue);
            this.environmentVariables.setProperty(propertyName, localPropertyValue);
        }
    }

    private File getLocalPreferencesFile() {
        return new File(this.homeDirectory, "thucydides.properties");
    }

    private File getLocalWorkingPreferencesFile() {
        return new File(this.workingDirectory, "thucydides.properties");
    }
}

