/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.issues.IssueTracking;

public class Formatter {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final Pattern shortIssueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private static final String FULL_ISSUE_NUMBER_REGEXP = "([A-Z][A-Z0-9-_]*)-\\d+";
    private static final Pattern fullIssueNumberPattern = Pattern.compile("([A-Z][A-Z0-9-_]*)-\\d+");
    private static final String ISSUE_LINK_FORMAT = "<a href=\"{0}\">{1}</a>";
    private final IssueTracking issueTracking;

    @Inject
    public Formatter(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
    }

    public static List<String> issuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        List<String> issuesWithHash = extractor.getShortenedIssues();
        List<String> allIssues = extractor.getFullIssues();
        allIssues.addAll(issuesWithHash);
        return allIssues;
    }

    public String addLinks(String value) {
        if (this.issueTracking == null) {
            return value;
        }
        String formattedValue = value;
        if (this.issueTracking.getIssueTrackerUrl() != null) {
            formattedValue = this.insertFullIssueTrackingUrls(value);
        }
        if (this.issueTracking.getShortenedIssueTrackerUrl() != null) {
            formattedValue = this.insertShortenedIssueTrackingUrls(formattedValue);
        }
        return formattedValue;
    }

    private String insertShortenedIssueTrackingUrls(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getShortenedIssueTrackerUrl();
        List<String> issues = Formatter.shortenedIssuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    public static List<String> shortenedIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getShortenedIssues();
    }

    public static List<String> fullIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getFullIssues();
    }

    private String insertFullIssueTrackingUrls(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = Formatter.fullIssuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, issue);
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }

    static class IssueExtractor {
        private String workingCopy;

        IssueExtractor(String initialValue) {
            this.workingCopy = initialValue;
        }

        public List<String> getShortenedIssues() {
            Matcher matcher = shortIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (matcher.find()) {
                String issue = matcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }

        public List<String> getFullIssues() {
            Matcher unhashedMatcher = fullIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (unhashedMatcher.find()) {
                String issue = unhashedMatcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, "");
            }
            return issues;
        }
    }
}

