/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.statistics.service.ClasspathTagProviderService;
import net.thucydides.core.statistics.service.TagProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathRequirementsProviderService
implements RequirementsProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathRequirementsProviderService.class);
    private ClasspathTagProviderService tagProviderService;

    @Inject
    public ClasspathRequirementsProviderService(ClasspathTagProviderService tagProviderService) {
        this.tagProviderService = tagProviderService;
    }

    @Override
    public List<RequirementsTagProvider> getRequirementsProviders() {
        ArrayList<RequirementsTagProvider> requirementsTagProviders = new ArrayList<RequirementsTagProvider>();
        List<TagProvider> tagProviders = this.tagProviderService.getTagProviders();
        this.logger.info("Using tag providers: {}", tagProviders);
        System.out.println("Using tag providers: " + tagProviders);
        for (TagProvider tagProvider : tagProviders) {
            if (!(tagProvider instanceof RequirementsTagProvider)) continue;
            requirementsTagProviders.add((RequirementsTagProvider)tagProvider);
        }
        return requirementsTagProviders;
    }
}

