/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.SimpleImageInfo;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcome {
    private static final int RECENT_TEST_RUN_COUNT = 10;
    private final String methodName;
    private final Class<?> testCase;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private String storedTitle;
    private Set<String> issues;
    private Set<String> additionalIssues;
    private Set<TestTag> tags;
    private long duration;
    private final long startTime;
    private Throwable testFailureCause;
    private TestResult annotatedResult = null;
    private Stack<TestStep> groupStack = new Stack();
    private IssueTracking issueTracking;
    private EnvironmentVariables environmentVariables;
    private String sessionId;
    private LinkGenerator linkGenerator;
    private TestStatistics statistics;
    private TagProviderService tagProviderService;
    private Optional<String> qualifier;

    public TestOutcome(String methodName) {
        this(methodName, null);
    }

    public TestOutcome(String methodName, Class<?> testCase) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = new HashSet<String>();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.qualifier = Optional.absent();
        if (testCase != null) {
            this.initializeStoryFrom(testCase);
        }
    }

    private TagProviderService getTagProviderService() {
        if (this.tagProviderService == null) {
            this.tagProviderService = (TagProviderService)Injectors.getInjector().getInstance(TagProviderService.class);
        }
        return this.tagProviderService;
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        }
        return this.environmentVariables;
    }

    protected TestOutcome(String methodName, Class<?> testCase, Story userStory) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        this.additionalIssues = new HashSet<String>();
        this.userStory = userStory;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
    }

    protected TestOutcome(long startTime, long duration, String title, String methodName, Class<?> testCase, List<TestStep> testSteps, Set<String> issues, Set<String> additionalIssues, Set<TestTag> tags, Story userStory, Throwable testFailureCause, TestResult annotatedResult, Optional<String> qualifier) {
        this.startTime = startTime;
        this.duration = duration;
        this.storedTitle = title;
        this.methodName = methodName;
        this.testCase = testCase;
        this.testSteps.addAll(testSteps);
        this.issues = issues;
        this.additionalIssues = additionalIssues;
        this.tags = tags;
        this.userStory = userStory;
        this.testFailureCause = testFailureCause;
        this.qualifier = qualifier;
        this.annotatedResult = annotatedResult;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    public TestOutcome withQualifier(String qualifier) {
        if (qualifier != null) {
            return new TestOutcome(this.startTime, this.duration, this.storedTitle, this.methodName, this.testCase, this.testSteps, this.issues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.annotatedResult, (Optional<String>)Optional.fromNullable((Object)qualifier));
        }
        return this;
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)) : Story.from(testCase);
        this.setUserStory(story);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return Lambda.join((Object)Lambda.extract(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
    }

    public String getTitle() {
        if (this.storedTitle == null) {
            return this.obtainTitleFromAnnotationOrMethodName();
        }
        return this.storedTitle;
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    private String obtainTitleFromAnnotationOrMethodName() {
        Optional<String> annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.methodName);
        String rootTitle = (String)annotatedTitle.or((Object)NameConverter.humanize(NameConverter.withNoArguments(this.methodName)));
        if (this.qualifier != null && this.qualifier.isPresent()) {
            return this.qualified(rootTitle);
        }
        return rootTitle;
    }

    private String qualified(String rootTitle) {
        return rootTitle + " [" + (String)this.qualifier.get() + "]";
    }

    public String getStoryTitle() {
        return this.getTitleFrom(this.userStory);
    }

    public String getPath() {
        if (this.userStory != null) {
            return this.userStory.getPath();
        }
        return null;
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName();
    }

    public String getReportName(ReportType type) {
        return ReportNamer.forReportType(type).getNormalizedTestNameFor(this);
    }

    public String getSimpleReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getSimpleTestNameFor(this);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(this.screenshotsIn(currentStep));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private List<Screenshot> screenshotsIn(TestStep currentStep) {
        return Lambda.convert(currentStep.getScreenshots(), this.toScreenshotsFor(currentStep));
    }

    private Converter<ScreenshotAndHtmlSource, Screenshot> toScreenshotsFor(final TestStep currentStep) {
        return new Converter<ScreenshotAndHtmlSource, Screenshot>(){

            public Screenshot convert(ScreenshotAndHtmlSource from) {
                return new Screenshot(from.getScreenshotFile().getName(), currentStep.getDescription(), TestOutcome.this.widthOf(from.getScreenshotFile()), currentStep.getException());
            }
        };
    }

    private int widthOf(File screenshot) {
        try {
            return new SimpleImageInfo(screenshot).getWidth();
        }
        catch (IOException e) {
            return 960;
        }
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<? extends TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return ImmutableList.copyOf(flattenedTestSteps);
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (this.testFailureCause != null) {
            return TestResult.FAILURE;
        }
        if (this.annotatedResult != null) {
            return this.annotatedResult;
        }
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
        } else {
            this.testSteps.add(step);
        }
        return this;
    }

    public TestOutcome withStep(TestStep step) {
        return this.recordStep(step);
    }

    public TestOutcome andStep(TestStep step) {
        return this.recordStep(step);
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null && this.getUserStory().getFeature() != null) {
            return this.getUserStory().getFeature();
        }
        return null;
    }

    public void setTitle(String title) {
        this.storedTitle = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.getCurrentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep getCurrentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    public TestStep getLastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep getCurrentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void setTestFailureCause(Throwable cause) {
        this.testFailureCause = cause;
    }

    public Throwable getTestFailureCause() {
        return this.testFailureCause;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
    }

    private Set<String> issues() {
        if (!this.thereAre(this.issues)) {
            this.issues = this.readIssues();
        }
        return this.issues;
    }

    public Set<String> getIssues() {
        HashSet<String> allIssues = new HashSet<String>(this.issues());
        if (this.thereAre(this.additionalIssues)) {
            allIssues.addAll(this.additionalIssues);
        }
        return allIssues;
    }

    public Class<?> getTestCase() {
        return this.testCase;
    }

    private boolean thereAre(Set<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public void addIssues(List<String> issues) {
        this.additionalIssues.addAll(issues);
    }

    private Set<String> readIssues() {
        HashSet<String> taggedIssues = new HashSet<String>();
        if (this.testCase != null) {
            this.addMethodLevelIssuesTo(taggedIssues);
            this.addClassLevelIssuesTo(taggedIssues);
        }
        this.addTitleLevelIssuesTo(taggedIssues);
        return taggedIssues;
    }

    private void addClassLevelIssuesTo(Set<String> issues) {
        String[] classIssues;
        String classIssue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForTestCase(this.testCase);
        if (classIssue != null) {
            issues.add(classIssue);
        }
        if ((classIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForTestCase(this.testCase)) != null) {
            issues.addAll(Arrays.asList(classIssues));
        }
    }

    private void addMethodLevelIssuesTo(Set<String> issues) {
        Optional<String> issue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForMethod(this.getMethodName());
        if (issue.isPresent()) {
            issues.add((String)issue.get());
        }
        String[] multipleIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForMethod(this.getMethodName());
        issues.addAll(Arrays.asList(multipleIssues));
    }

    private void addTitleLevelIssuesTo(Set<String> issues) {
        List<String> titleIssues = Formatter.issuesIn(this.getTitle());
        if (!titleIssues.isEmpty()) {
            issues.addAll(titleIssues);
        }
    }

    public String getFormattedIssues() {
        Set<String> issues = this.getIssues();
        if (!issues.isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)Lambda.on(String.class));
            return "(" + this.getFormatter().addLinks(StringUtils.join((Iterable)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        this.issues().add(issue);
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.setTestFailureCause(failure.getException());
        TestStep lastTestStep = this.testSteps.get(this.testSteps.size() - 1);
        lastTestStep.failedWith(new StepFailureException(failure.getMessage(), failure.getException()));
    }

    public Set<TestTag> getTags() {
        if (this.tags == null) {
            this.tags = this.getTagsUsingTagProviders(this.getTagProviderService().getTagProviders());
        }
        return ImmutableSet.copyOf(this.tags);
    }

    private Set<TestTag> getTagsUsingTagProviders(List<TagProvider> tagProviders) {
        HashSet tags = Sets.newHashSet();
        for (TagProvider tagProvider : tagProviders) {
            Set<TestTag> providedTags = tagProvider.getTagsFor(this);
            if (providedTags == null) continue;
            tags.addAll(tagProvider.getTagsFor(this));
        }
        return tags;
    }

    public void setTags(Set<TestTag> tags) {
        this.tags = Sets.newHashSet(tags);
    }

    public void addTags(List<TestTag> tags) {
        this.getTags();
        this.tags.addAll(tags);
    }

    public List<String> getIssueKeys() {
        return Lambda.convert(this.getIssues(), this.toIssueKeys());
    }

    private Converter<String, String> toIssueKeys() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                String issueKey = issueNumber;
                if (issueKey.startsWith("#")) {
                    issueKey = issueKey.substring(1);
                }
                if (StringUtils.isNumeric((CharSequence)issueKey) && TestOutcome.this.getProjectPrefix() != null) {
                    Joiner joiner = Joiner.on((String)"-");
                    issueKey = joiner.join((Object)TestOutcome.this.getProjectPrefix(), (Object)issueKey, new Object[0]);
                }
                return issueKey;
            }
        };
    }

    private String getProjectPrefix() {
        return ThucydidesSystemProperty.PROJECT_KEY.from(this.getEnvironmentVariables());
    }

    public String getQualifiedMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            String qualifierWithoutSpaces = ((String)this.qualifier.get()).replaceAll(" ", "_");
            return this.getMethodName() + "_" + qualifierWithoutSpaces;
        }
        return this.getMethodName();
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Integer getSuccessCount() {
        return this.count(this.successfulSteps()).in(this.getLeafTestSteps());
    }

    public Integer getFailureCount() {
        return this.count(this.failingSteps()).in(this.getLeafTestSteps());
    }

    public Integer getIgnoredCount() {
        return this.count(this.ignoredSteps()).in(this.getLeafTestSteps());
    }

    public Integer getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Integer getSkippedCount() {
        return this.count(this.skippedSteps()).in(this.getLeafTestSteps());
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING || this.getStepCount() == 0;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        if (this.duration == 0L && this.testSteps != null && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public String getVideoLink() {
        return this.linkGenerator.linkFor(this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    StepCountBuilder count(StepFilter filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(){

            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(){

            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(){

            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(){

            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    public void setStatistics(TestStatistics statistics) {
        this.statistics = statistics;
    }

    public TestStatistics getStatistics() {
        return this.statistics;
    }

    public double getOverallStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getOverallPassRate();
    }

    public double getRecentStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getPassRate().overTheLast(10).testRuns();
    }

    public Long getRecentTestRunCount() {
        if (this.getStatistics() == null) {
            return 0L;
        }
        return this.getStatistics().getTotalTestRuns() > 10L ? 10L : this.getStatistics().getTotalTestRuns();
    }

    public int getRecentPassCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.SUCCESS);
    }

    public int getRecentFailCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.FAILURE);
    }

    public int getRecentPendingCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.PENDING);
    }

    public DateTime getStartTime() {
        return new DateTime(this.startTime);
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StepCountBuilder {
        private final StepFilter filter;

        public StepCountBuilder(StepFilter filter) {
            this.filter = filter;
        }

        int in(List<TestStep> steps) {
            int count = 0;
            for (TestStep step : steps) {
                if (!this.filter.apply(step)) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

