/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public enum ThucydidesSystemProperty {
    DRIVER("webdriver.driver"),
    BASE_URL("webdriver.base.url"),
    REMOTE_URL("webdriver.remote.url"),
    REMOTE_DRIVER("webdriver.remote.driver"),
    PROJECT_KEY("thucydides.project.key"),
    THUCYDIDES_HOME("thucydides.home"),
    THUCYDIDES_DATABASE_JDBC_OPTIONS("thucydides.database.jdbc.options"),
    RECORD_STATISTICS("thucydides.record.statistics"),
    REPORT_RESOURCE_PATH("thucydides.report.resources"),
    OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    ONLY_SAVE_FAILING_SCREENSHOTS("thucydides.only.save.failing.screenshots"),
    DRIVER_CAPABILITIES("thucydides.driver.capabilities"),
    VERBOSE_SCREENSHOTS("thucydides.verbose.screenshots"),
    VERBOSE_STEPS("thucydides.verbose.steps"),
    THUCYDIDES_TAKE_SCREENSHOTS("thucydides.take.screenshots"),
    SHOW_STEP_DETAILS("thucydides.reports.show.step.details"),
    RESTART_BROWSER_FREQUENCY("thucydides.restart.browser.frequency"),
    STEP_DELAY("thucycides.step.delay"),
    ELEMENT_TIMEOUT("thucydides.timeout"),
    REFUSE_UNTRUSTED_CERTIFICATES("refuse.untrusted.certificates"),
    UNIQUE_BROWSER("thucydides.use.unique.browser"),
    ESTIMATED_AVERAGE_STEP_COUNT("thucydides.estimated.average.step.count"),
    ESTIMATED_TESTS_PER_REQUIREMENT("thucydides.estimated.tests.per.requirement"),
    ISSUE_TRACKER_URL("thucydides.issue.tracker.url"),
    NATIVE_EVENTS("thucydides.native.events"),
    JIRA_URL("jira.url"),
    JIRA_PROJECT("jira.project"),
    JIRA_USERNAME("jira.username"),
    JIRA_PASSWORD("jira.password"),
    HISTORY_BASE_DIRECTORY("thucydides.history"),
    SNAPSHOT_HEIGHT("thucydides.browser.height"),
    SNAPSHOT_WIDTH("thucydides.browser.width"),
    RESIZED_WIDTH("thucydides.resized.image.width"),
    PUBLIC_URL("thucydides.public.url"),
    ACTIVATE_FIREBUGS("thucydides.activate.firebugs"),
    SECURITY_ENABLE_JAVA("security.enable_java"),
    ACTIVTE_HIGHLIGHTING("thucydides.activate.highlighting"),
    BATCH_STRATEGY("thucydides.batch.strategy"),
    BATCH_COUNT("thucydides.batch.count"),
    BATCH_SIZE("thucydides.batch.size"),
    BATCH_NUMBER("thucydides.batch.number"),
    PROXY_URL("thucydides.proxy.http"),
    PROXY_PORT("thucydides.proxy.http_port"),
    TIMEOUTS_IMPLICIT_WAIT("webdriver.timeouts.implicitlywait"),
    EXTENSION_PACKAGES("thucydides.ext.packages"),
    CHROME_SWITCHES("chrome.switches"),
    FIREFOX_PREFERENCES("firefox.preferences"),
    JQUERY_INTEGRATION("thucydides.jquery.integration"),
    SAUCELABS_TARGET_PLATFORM("saucelabs.target.platform"),
    SAUCELABS_DRIVER_VERSION("saucelabs.driver.version"),
    SAUCELABS_TEST_NAME("saucelabs.test.name"),
    SAUCELABS_URL("saucelabs.url"),
    SAUCELABS_ACCESS_KEY("saucelabs.access.key"),
    SAUCELABS_USER_ID("saucelabs.user.id"),
    SAUCELABS_IMPLICIT_TIMEOUT("saucelabs.implicit.timeout"),
    SAUCELABS_RECORD_SCREENSHOTS("saucelabs.record.screenshots"),
    FILE_IO_RETRY_TIMEOUT("thucydides.file.io.retry.timeout"),
    LOGGING("thucydides.logging"),
    THUCYDIDES_TEST_ROOT("thucydides.test.root"),
    REQUIREMENTS_DIRECTORY("thucydides.requirements.dir"),
    LOWEST_REQUIREMENT_TYPE("thucydides.lowest.requirement.type"),
    REQUIREMENT_TYPES("thucydides.requirement.types"),
    REQUIREMENT_EXCLUSIONS("thucydides.requirement.exclusions"),
    LOCATOR_FACTORY("thucydides.locator.factory"),
    DATA_DIRECTORY("thucydides.data.dir"),
    PROPERTIES("properties"),
    STATISTICS_DRIVER("thucydides.statistics.driver_class"),
    STATISTICS_URL("thucydides.statistics.url"),
    STATISTICS_USERNAME("thucydides.statistics.username"),
    STATISTICS_PASSWORD("thucydides.statistics.password"),
    STATISTICS_DIALECT("thucydides.statistics.dialect"),
    TEST_REQUIREMENTS_ROOT("thucydides.test.requirements.basedir"),
    THUCYDIDES_STORE_HTML_SOURCE("thucydides.store.html.source"),
    THUCYDIDES_KEEP_UNSCALED_SCREENSHOTS("thucydides.keep.unscaled.screenshots"),
    TAGS("tags"),
    THUCYDIDES_EXTRA_COLUMNS("thucydides.csv.extra.columns"),
    THUCYDIDES_CONSOLE_HEADINGS("thucydides.console.headings"),
    THUCYDIDES_NARRATIVE_FORMAT("narrative.format");

    private String propertyName;
    public static final int DEFAULT_HEIGHT = 700;
    public static final int DEFAULT_WIDTH = 960;

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public String from(EnvironmentVariables environmentVariables) {
        return environmentVariables.getProperty(this.getPropertyName());
    }

    public String from(EnvironmentVariables environmentVariables, String defaultValue) {
        String value = environmentVariables.getProperty(this.getPropertyName());
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean isDefinedIn(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)this.from(environmentVariables));
    }
}

