/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.InvalidStepsFieldException;
import net.thucydides.core.annotations.Steps;
import net.thucydides.core.reflection.FieldSetter;
import net.thucydides.core.steps.ScenarioSteps;

public class StepsAnnotatedField {
    private Field field;
    private static final String NO_ANNOTATED_FIELD_ERROR = "No field annotated with @Steps was found in the test case.";

    public static List<StepsAnnotatedField> findMandatoryAnnotatedFields(Class<?> clazz) {
        List<StepsAnnotatedField> annotatedFields = StepsAnnotatedField.findOptionalAnnotatedFields(clazz);
        if (annotatedFields.isEmpty()) {
            throw new InvalidStepsFieldException(NO_ANNOTATED_FIELD_ERROR);
        }
        return annotatedFields;
    }

    public static List<StepsAnnotatedField> findOptionalAnnotatedFields(Class<?> clazz) {
        ArrayList<StepsAnnotatedField> annotatedFields = new ArrayList<StepsAnnotatedField>();
        for (Field field : Fields.of(clazz).allFields()) {
            if (!StepsAnnotatedField.fieldIsAnnotated(field)) continue;
            annotatedFields.add(new StepsAnnotatedField(field));
        }
        return annotatedFields;
    }

    private static boolean fieldIsAnnotated(Field aField) {
        Steps fieldAnnotation = StepsAnnotatedField.annotationFrom(aField);
        return fieldAnnotation != null;
    }

    private static Steps annotationFrom(Field aField) {
        Steps annotationOnField = null;
        if (StepsAnnotatedField.isFieldAnnotated(aField)) {
            annotationOnField = aField.getAnnotation(Steps.class);
        }
        return annotationOnField;
    }

    private static boolean isFieldAnnotated(Field field) {
        return StepsAnnotatedField.fieldIsAnnotatedCorrectly(field);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Steps.class) != null;
    }

    protected StepsAnnotatedField(Field field) {
        this.field = field;
    }

    protected FieldSetter set(Object targetObject) {
        return new FieldSetter(this.field, targetObject);
    }

    public void setValue(Object testCase, Object steps) {
        try {
            this.set(testCase).to(steps);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + this.field, e);
        }
    }

    public boolean isInstantiated(Object testCase) {
        try {
            this.field.setAccessible(true);
            Object fieldValue = this.field.get(testCase);
            return fieldValue != null;
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + this.field, e);
        }
    }

    public Class<? extends ScenarioSteps> getFieldClass() {
        return this.field.getType();
    }
}

