/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;

public class OutcomeCounter
extends TestOutcomeCounter {
    private final TestOutcomes outcomes;

    public OutcomeCounter(TestType testType, TestOutcomes outcomes) {
        super(testType);
        this.outcomes = outcomes.ofType(testType);
    }

    public int withResult(String expectedResult) {
        return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
    }

    public int withResult(TestResult expectedResult) {
        return (Integer)Lambda.sum(this.outcomes.getOutcomes(), (Object)((TestOutcome)Lambda.on(TestOutcome.class)).countResults(expectedResult));
    }

    public int getTotal() {
        return this.outcomes.getTotal();
    }

    public int withIndeterminateResult() {
        return this.outcomes.getTotal() - this.withResult(TestResult.SUCCESS) - this.withResult(TestResult.FAILURE) - this.withResult(TestResult.ERROR);
    }
}

