/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.adaptors.TestOutcomeAdaptor;
import net.thucydides.core.reports.html.HtmlAcceptanceTestReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;

public class TestOutcomeAdaptorReporter
extends ThucydidesReporter {
    private List<TestOutcomeAdaptor> adaptors = Lists.newArrayList();

    public void generateReportsFrom(File sourceDirectory) throws IOException {
        this.setupOutputDirectoryIfRequired();
        for (TestOutcomeAdaptor adaptor : this.adaptors) {
            List<TestOutcome> outcomes = adaptor.loadOutcomesFrom(sourceDirectory);
            this.generateReportsFor(outcomes);
        }
    }

    private void setupOutputDirectoryIfRequired() {
        if (this.getOutputDirectory() != null) {
            this.getOutputDirectory().mkdirs();
        }
    }

    private void generateReportsFor(List<TestOutcome> outcomes) throws IOException {
        AcceptanceTestReporter xmlTestOutcomeReporter = this.getXMLReporter();
        AcceptanceTestReporter htmlAcceptanceTestReporter = this.getHTMLReporter();
        TestOutcomes allOutcomes = TestOutcomes.of(outcomes);
        for (TestOutcome outcome : outcomes) {
            xmlTestOutcomeReporter.generateReportFor(outcome, allOutcomes);
            htmlAcceptanceTestReporter.generateReportFor(outcome, allOutcomes);
        }
    }

    private AcceptanceTestReporter getXMLReporter() {
        XMLTestOutcomeReporter reporter = new XMLTestOutcomeReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    private AcceptanceTestReporter getHTMLReporter() {
        HtmlAcceptanceTestReporter reporter = new HtmlAcceptanceTestReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    public void registerAdaptor(TestOutcomeAdaptor adaptor) {
        this.adaptors.add(adaptor);
    }
}

