/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import ch.lambdaj.Lambda;
import java.util.List;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;

public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;
    private final int requirementsWithoutTests;
    private final int estimatedUnimplementedTests;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, int requirementsWithoutTests, int estimatedUnimplementedTests, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.requirementsWithoutTests = requirementsWithoutTests;
        this.estimatedUnimplementedTests = estimatedUnimplementedTests;
        this.issueTracking = issueTracking;
    }

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this(requirement, testOutcomes, 0, 0, issueTracking);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public boolean isComplete() {
        return this.getTestOutcomes().getResult() == TestResult.SUCCESS && this.allChildRequirementsAreSuccessful();
    }

    public boolean isFailure() {
        return this.getTestOutcomes().getResult() == TestResult.FAILURE || this.anyChildRequirementsAreFailures();
    }

    public boolean isPending() {
        return this.getTestOutcomes().getResult() == TestResult.PENDING || this.anyChildRequirementsArePending();
    }

    public int getFlattenedRequirementCount() {
        return this.requirement.getNestedChildren().size() + 1;
    }

    public int getRequirementsWithoutTestsCount() {
        return this.requirementsWithoutTests;
    }

    private boolean allChildRequirementsAreSuccessful() {
        if (this.requirement.hasChildren()) {
            return this.allChildRequirementsAreSuccessfulFor(this.requirement.getChildren());
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailures() {
        return this.anyChildRequirementsAreFailuresFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsArePending() {
        return this.anyChildRequirementsArePendingFor(this.requirement.getChildren());
    }

    private boolean allChildRequirementsAreSuccessfulFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (!childOutcomes.isComplete()) {
                return false;
            }
            if (this.allChildRequirementsAreSuccessfulFor(childRequirement.getChildren())) continue;
            return false;
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailuresFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isFailure()) {
                return true;
            }
            if (!this.anyChildRequirementsAreFailuresFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsArePendingFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isPending()) {
                return true;
            }
            if (!this.anyChildRequirementsArePendingFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return this.getFormatter().addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }

    public int getTestCount() {
        return this.testOutcomes.getTotal();
    }

    public int getEstimatedUnimplementedTests() {
        return this.estimatedUnimplementedTests;
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.testOutcomes.getTotal();
        return totalImplementedTests + this.estimatedUnimplementedTests;
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return this.getFormattedPercentage(TestType.ANY);
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public boolean testsRequirement(Requirement requirement) {
        return requirement.equals(this.getRequirement()) || this.testOutcomes.containsTag(requirement.asTag());
    }

    public RequirementsProportionCounter getPercent() {
        return this.percentage(TestType.ANY);
    }

    public RequirementsProportionCounter percentage(String testType) {
        return this.percentage(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter percentage(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public OutcomeCounter getTotal() {
        return new OutcomeCounter(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType);
    }

    public OutcomeCounter count(String testType) {
        return new OutcomeCounter(TestType.valueOf(testType.toUpperCase()));
    }

    public class OutcomeCounter
    extends TestOutcomeCounter {
        public OutcomeCounter(TestType testType) {
            super(testType);
        }

        public int withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public int withResult(TestResult expectedResult) {
            return (Integer)Lambda.sum(RequirementOutcome.this.testOutcomes.getOutcomes(), (Object)((TestOutcome)Lambda.on(TestOutcome.class)).countResults(expectedResult, this.testType));
        }

        public int withIndeterminateResult() {
            return RequirementOutcome.this.testOutcomes.getTotal() - this.withResult(TestResult.SUCCESS) - this.withResult(TestResult.FAILURE) - this.withResult(TestResult.ERROR);
        }
    }
}

