/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import net.thucydides.core.annotations.locators.SmartElementProxyCreator;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.SystemVariableBasedBatchManager;
import net.thucydides.core.fixtureservices.ClasspathFixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.issues.SystemPropertiesIssueTracking;
import net.thucydides.core.logging.ThucydidesLogging;
import net.thucydides.core.pages.InternalSystemClock;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.reports.renderer.Asciidoc;
import net.thucydides.core.reports.renderer.AsciidocMarkupRenderer;
import net.thucydides.core.reports.renderer.MarkupRenderer;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.reports.saucelabs.SaucelabsLinkGenerator;
import net.thucydides.core.reports.templates.FreeMarkerTemplateManager;
import net.thucydides.core.reports.templates.TemplateManager;
import net.thucydides.core.requirements.ClasspathRequirementsProviderService;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.screenshots.SingleThreadScreenshotProcessor;
import net.thucydides.core.statistics.AtomicTestCount;
import net.thucydides.core.statistics.TestCount;
import net.thucydides.core.statistics.database.LocalDatabase;
import net.thucydides.core.statistics.database.LocalH2ServerDatabase;
import net.thucydides.core.statistics.service.ClasspathTagProviderService;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.steps.ConsoleLoggingListener;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.di.ClasspathDependencyInjectorService;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesFileLocalPreferences;
import net.thucydides.core.util.SystemEnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ElementProxyCreator;
import net.thucydides.core.webdriver.SystemPropertiesConfiguration;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebdriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesModule
extends AbstractModule {
    private final Logger LOGGER = LoggerFactory.getLogger(ThucydidesModule.class);

    protected void configure() {
        this.bind(SystemClock.class).to(InternalSystemClock.class).in(Singleton.class);
        this.bind(TemplateManager.class).to(FreeMarkerTemplateManager.class).in(Singleton.class);
        this.bind(Configuration.class).to(SystemPropertiesConfiguration.class).in(Singleton.class);
        this.bind(IssueTracking.class).to(SystemPropertiesIssueTracking.class).in(Singleton.class);
        this.bind(WebdriverManager.class).to(ThucydidesWebdriverManager.class).in(Singleton.class);
        this.bind(BatchManager.class).to(SystemVariableBasedBatchManager.class);
        this.bind(LinkGenerator.class).to(SaucelabsLinkGenerator.class);
        this.bind(ScreenshotProcessor.class).to(SingleThreadScreenshotProcessor.class).in(Singleton.class);
        this.bind(TagProviderService.class).to(ClasspathTagProviderService.class).in(Singleton.class);
        this.bind(RequirementsProviderService.class).to(ClasspathRequirementsProviderService.class).in(Singleton.class);
        this.bind(DependencyInjectorService.class).to(ClasspathDependencyInjectorService.class).in(Singleton.class);
        this.bind(FixtureProviderService.class).to(ClasspathFixtureProviderService.class).in(Singleton.class);
        this.bind(StepListener.class).annotatedWith(ThucydidesLogging.class).to(ConsoleLoggingListener.class).in(Singleton.class);
        this.bind(ElementProxyCreator.class).to(SmartElementProxyCreator.class).in(Singleton.class);
        this.bind(TestCount.class).to(AtomicTestCount.class).in(Singleton.class);
        this.bind(MarkupRenderer.class).annotatedWith(Asciidoc.class).to(AsciidocMarkupRenderer.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    public EnvironmentVariables provideEnvironmentVariables() {
        return this.createEnvironmentVariables();
    }

    protected EnvironmentVariables createEnvironmentVariables() {
        SystemEnvironmentVariables environmentVariables = new SystemEnvironmentVariables();
        PropertiesFileLocalPreferences localPreferences = new PropertiesFileLocalPreferences(environmentVariables);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            this.LOGGER.error("Could not load local preferences", (Throwable)e);
        }
        return environmentVariables;
    }

    @Provides
    @Singleton
    @Inject
    public LocalDatabase provideLocalDatabase(EnvironmentVariables environmentVariables) {
        return new LocalH2ServerDatabase(environmentVariables);
    }
}

