/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.CapabilitySet;
import net.thucydides.core.webdriver.DriverSource;
import net.thucydides.core.webdriver.ElementProxyCreator;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import net.thucydides.core.webdriver.phantomjs.PhantomJSCapabilityEnhancer;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "firefox";
    public static final String REMOTE_DRIVER = "remote";
    private final WebdriverInstanceFactory webdriverInstanceFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);
    private ProfilesIni allProfiles;
    private static final int DEFAULT_HEIGHT = 700;
    private static final int DEFAULT_WIDTH = 960;
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;
    private final FixtureProviderService fixtureProviderService;
    private final ElementProxyCreator proxyCreator;
    private final Integer EXTRA_TIME_TO_TAKE_SCREENSHOTS = 180;

    public WebDriverFactory() {
        this(new WebdriverInstanceFactory(), (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(new WebdriverInstanceFactory(), environmentVariables);
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables) {
        this(webdriverInstanceFactory, environmentVariables, new FirefoxProfileEnhancer(environmentVariables));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        this(webdriverInstanceFactory, environmentVariables, firefoxProfileEnhancer, (FixtureProviderService)Injectors.getInjector().getInstance(FixtureProviderService.class), (ElementProxyCreator)Injectors.getInjector().getInstance(ElementProxyCreator.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer, FixtureProviderService fixtureProviderService) {
        this(webdriverInstanceFactory, environmentVariables, firefoxProfileEnhancer, fixtureProviderService, (ElementProxyCreator)Injectors.getInjector().getInstance(ElementProxyCreator.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables, FirefoxProfileEnhancer firefoxProfileEnhancer, FixtureProviderService fixtureProviderService, ElementProxyCreator proxyCreator) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = firefoxProfileEnhancer;
        this.fixtureProviderService = fixtureProviderService;
        this.proxyCreator = proxyCreator;
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        if (this.usesSauceLabs() && driverType != SupportedWebDriver.HTMLUNIT) {
            return RemoteWebDriver.class;
        }
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables));
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            WebDriver driver = this.isARemoteDriver(driverClass) || this.shouldUseARemoteDriver() || this.saucelabsUrlIsDefined() ? this.newRemoteDriver() : (this.isAFirefoxDriver(driverClass) ? this.firefoxDriver() : (this.isAnHtmlUnitDriver(driverClass) ? this.htmlunitDriver() : (this.isAPhantomJSDriver(driverClass) ? this.phantomJSDriver() : (this.isAChromeDriver(driverClass) ? this.chromeDriver() : (this.isASafariDriver(driverClass) ? this.safariDriver() : (this.isAnInternetExplorerDriver(driverClass) ? this.internetExplorerDriver() : (this.isAProvidedDriver(driverClass) ? this.providedDriver() : this.newDriverInstanceFrom(driverClass))))))));
            this.setImplicitTimeoutsIfSpecified(driver);
            this.redimensionBrowser(driver);
            JavascriptSupport.activateJavascriptSupportFor(driver);
            return driver;
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private boolean isAProvidedDriver(Class<? extends WebDriver> driverClass) {
        return ProvidedDriver.class.isAssignableFrom(driverClass);
    }

    private WebDriver providedDriver() {
        String providedDriverType = this.environmentVariables.getProperty(ThucydidesSystemProperty.PROVIDED_DRIVER_TYPE);
        Preconditions.checkNotNull((Object)providedDriverType, (Object)"No provider type was specified in 'webdriver.provided.type'");
        String providedImplementation = this.environmentVariables.getProperty("webdriver.provided." + providedDriverType);
        Preconditions.checkNotNull((Object)providedDriverType, (Object)("No provider implementation was specified in 'webdriver.provided.'" + providedDriverType));
        try {
            DriverSource driverSource = (DriverSource)Class.forName(providedImplementation).newInstance();
            return driverSource.newDriver();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate the custom webdriver provider of type " + providedImplementation);
        }
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.TIMEOUTS_IMPLICIT_WAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.TIMEOUTS_IMPLICIT_WAIT.getPropertyName(), (Integer)0);
            driver.manage().timeouts().implicitlyWait((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.REMOTE_URL.isDefinedIn(this.environmentVariables);
    }

    private WebDriver newDriverInstanceFrom(Class<? extends WebDriver> driverClass) throws IllegalAccessException, InstantiationException {
        return this.webdriverInstanceFactory.newInstanceOf(driverClass);
    }

    private WebDriver newRemoteDriver() throws MalformedURLException {
        WebDriver driver = null;
        driver = this.saucelabsUrlIsDefined() ? this.buildSaucelabsDriver() : this.buildRemoteDriver();
        Augmenter augmenter = new Augmenter();
        return augmenter.augment(driver);
    }

    private WebDriver buildRemoteDriver() throws MalformedURLException {
        String remoteUrl = ThucydidesSystemProperty.REMOTE_URL.from(this.environmentVariables);
        return this.webdriverInstanceFactory.newRemoteDriver(new URL(remoteUrl), this.buildRemoteCapabilities());
    }

    private boolean saucelabsUrlIsDefined() {
        return ThucydidesSystemProperty.SAUCELABS_URL.isDefinedIn(this.environmentVariables);
    }

    private WebDriver buildSaucelabsDriver() throws MalformedURLException {
        String saucelabsUrl = ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables);
        WebDriver driver = this.webdriverInstanceFactory.newRemoteDriver(new URL(saucelabsUrl), this.findSaucelabsCapabilities());
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.from(this.environmentVariables))) {
            int implicitWait = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.getPropertyName(), (Integer)30);
            driver.manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.SECONDS);
        }
        return driver;
    }

    private Capabilities findSaucelabsCapabilities() {
        String driver = ThucydidesSystemProperty.DRIVER.from(this.environmentVariables);
        DesiredCapabilities capabilities = this.capabilitiesForDriver(driver);
        this.configureBrowserVersion(capabilities);
        this.configureTargetPlatform(capabilities);
        this.configureTestName(capabilities);
        capabilities.setJavascriptEnabled(true);
        return capabilities;
    }

    private void configureBrowserVersion(DesiredCapabilities capabilities) {
        String driverVersion = ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)driverVersion)) {
            capabilities.setCapability("version", driverVersion);
        }
    }

    private void configureTargetPlatform(DesiredCapabilities capabilities) {
        String platformValue = ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)platformValue)) {
            capabilities.setCapability("platform", this.platformFrom(platformValue));
        }
    }

    private void configureTestName(DesiredCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            String guessedTestName = this.bestGuessOfTestName();
            if (guessedTestName != null) {
                capabilities.setCapability("name", this.bestGuessOfTestName());
            }
        }
    }

    private String bestGuessOfTestName() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (this.isATestMethod(callingMethod)) {
                    return NameConverter.humanize(elt.getMethodName());
                }
                if (!this.isASetupMethod(callingMethod)) continue;
                return NameConverter.humanize(callingClass.getSimpleName());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isATestMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Test.class) != null;
    }

    private boolean isASetupMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Before.class) != null || callingMethod.getAnnotation(BeforeClass.class) != null;
    }

    private Platform platformFrom(String platformValue) {
        return Platform.valueOf((String)platformValue.toUpperCase());
    }

    private Capabilities buildRemoteCapabilities() {
        String driver = ThucydidesSystemProperty.REMOTE_DRIVER.from(this.environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.DRIVER.from(this.environmentVariables);
        }
        return this.capabilitiesForDriver(driver);
    }

    private DesiredCapabilities capabilitiesForDriver(String driver) {
        if (driver == null) {
            driver = REMOTE_DRIVER;
        }
        SupportedWebDriver driverType = this.driverTypeFor(driver);
        Preconditions.checkNotNull((Object)((Object)driverType), (Object)"Unsupported remote driver type: ");
        if (driverType == SupportedWebDriver.REMOTE) {
            return (DesiredCapabilities)this.enhancedCapabilities(this.remoteCapabilities());
        }
        return (DesiredCapabilities)this.enhancedCapabilities(this.realBrowserCapabilities(driverType));
    }

    private SupportedWebDriver driverTypeFor(String driver) {
        String normalizedDriverName = driver.toUpperCase();
        if (!SupportedWebDriver.listOfSupportedDrivers().contains(normalizedDriverName)) {
            SupportedWebDriver closestDriver = SupportedWebDriver.getClosestDriverValueTo(normalizedDriverName);
            throw new AssertionError((Object)("Unsupported driver for webdriver.driver or webdriver.remote.driver: " + driver + ". Did you mean " + closestDriver.toString().toLowerCase() + "?"));
        }
        return SupportedWebDriver.valueOf(normalizedDriverName);
    }

    private DesiredCapabilities realBrowserCapabilities(SupportedWebDriver driverType) {
        DesiredCapabilities capabilities = null;
        switch (driverType) {
            case CHROME: {
                capabilities = this.chromeCapabilities();
                break;
            }
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                capabilities.setCapability("firefox_profile", (Object)this.buildFirefoxProfile());
                break;
            }
            case HTMLUNIT: {
                capabilities = DesiredCapabilities.htmlUnit();
                break;
            }
            case OPERA: {
                capabilities = DesiredCapabilities.opera();
                break;
            }
            case IEXPLORER: {
                capabilities = DesiredCapabilities.internetExplorer();
                break;
            }
            default: {
                capabilities = new DesiredCapabilities();
                capabilities.setJavascriptEnabled(true);
            }
        }
        return (DesiredCapabilities)this.enhancedCapabilities(capabilities);
    }

    private DesiredCapabilities remoteCapabilities() {
        String remoteBrowser = ThucydidesSystemProperty.REMOTE_DRIVER.from(this.environmentVariables, DEFAULT_DRIVER);
        DesiredCapabilities capabilities = this.realBrowserCapabilities(this.driverTypeFor(remoteBrowser));
        capabilities.setCapability("idle-timeout", (Object)this.EXTRA_TIME_TO_TAKE_SCREENSHOTS);
        Boolean recordScreenshotsInSaucelabs = this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.SAUCELABS_RECORD_SCREENSHOTS, false);
        capabilities.setCapability("record-screenshots", (Object)recordScreenshotsInSaucelabs);
        return capabilities;
    }

    private DesiredCapabilities addExtraCatabilitiesTo(DesiredCapabilities capabilities) {
        CapabilitySet capabilitySet = new CapabilitySet(this.environmentVariables);
        Map<String, Object> extraCapabilities = capabilitySet.getCapabilities();
        for (String capabilityName : extraCapabilities.keySet()) {
            capabilities.setCapability(capabilityName, extraCapabilities.get(capabilityName));
        }
        this.addCapabilitiesFromFixtureServicesTo(capabilities);
        return capabilities;
    }

    public void setupFixtureServices() throws FixtureException {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.setup();
        }
    }

    public void shutdownFixtureServices() {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.shutdown();
        }
    }

    private void addCapabilitiesFromFixtureServicesTo(DesiredCapabilities capabilities) {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.addCapabilitiesTo(capabilities);
        }
    }

    private WebDriver htmlunitDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setJavascriptEnabled(true);
        return this.webdriverInstanceFactory.newHtmlUnitDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver phantomJSDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
        PhantomJSCapabilityEnhancer enhancer = new PhantomJSCapabilityEnhancer(this.environmentVariables);
        enhancer.enhanceCapabilities(capabilities);
        return this.webdriverInstanceFactory.newPhantomDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver firefoxDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        FirefoxProfile profile = this.buildFirefoxProfile();
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        capabilities.setCapability("firefox_profile", (Object)profile);
        return this.webdriverInstanceFactory.newFirefoxDriver(this.enhancedCapabilities(capabilities));
    }

    private WebDriver chromeDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        DesiredCapabilities capabilities = this.chromeCapabilities();
        return this.webdriverInstanceFactory.newChromeDriver(this.enhancedCapabilities(capabilities));
    }

    private DesiredCapabilities chromeCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        capabilities.setCapability("chromeOptions", (Object)this.optionsFromSwitches(chromeSwitches));
        capabilities.setCapability("chrome.switches", chromeSwitches);
        return capabilities;
    }

    private ChromeOptions optionsFromSwitches(String chromeSwitches) {
        ChromeOptions options = new ChromeOptions();
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            ArrayList arguments = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)chromeSwitches));
            options.addArguments((List)arguments);
        }
        return options;
    }

    private WebDriver safariDriver() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.webdriverInstanceFactory.newSafariDriver(this.enhancedCapabilities(DesiredCapabilities.safari()));
    }

    private WebDriver internetExplorerDriver() {
        return this.webdriverInstanceFactory.newInternetExplorerDriver(this.enhancedCapabilities(DesiredCapabilities.internetExplorer()));
    }

    private Capabilities enhancedCapabilities(DesiredCapabilities capabilities) {
        return this.addExtraCatabilitiesTo(capabilities);
    }

    private Dimension getRequestedBrowserSize() {
        int height = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_HEIGHT, (Integer)700);
        int width = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.SNAPSHOT_WIDTH, (Integer)960);
        return new Dimension(width, height);
    }

    private void redimensionBrowser(WebDriver driver) {
        if (this.supportsScreenResizing(driver) && this.browserDimensionsSpecified()) {
            this.resizeBrowserTo(driver, this.getRequestedBrowserSize().height, this.getRequestedBrowserSize().width);
        }
    }

    private boolean browserDimensionsSpecified() {
        String snapshotWidth = this.environmentVariables.getProperty(ThucydidesSystemProperty.SNAPSHOT_WIDTH);
        String snapshotHeight = this.environmentVariables.getProperty(ThucydidesSystemProperty.SNAPSHOT_HEIGHT);
        return snapshotWidth != null || snapshotHeight != null;
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        return this.isNotAMocked(driver) && !this.isAnHtmlUnitDriver(this.getDriverClass(driver));
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock");
    }

    protected void resizeBrowserTo(WebDriver driver, int height, int width) {
        LOGGER.info("Setting browser dimensions to {}/{}", (Object)height, (Object)width);
        if (this.usesFirefox(driver) || this.usesInternetExplorer(driver)) {
            driver.manage().window().setSize(new Dimension(width, height));
        } else if (this.usesChrome(driver)) {
            ((JavascriptExecutor)driver).executeScript("window.open('about:blank','_blank','width=#{width},height=#{height}');", new Object[0]);
            Set windowHandles = driver.getWindowHandles();
            windowHandles.remove(driver.getWindowHandle());
            String newWindowHandle = windowHandles.toArray(new String[0])[0];
            driver.switchTo().window(newWindowHandle);
        }
        String resizeWindow = "window.resizeTo(" + width + "," + height + ")";
        ((JavascriptExecutor)driver).executeScript(resizeWindow, new Object[0]);
    }

    private boolean isARemoteDriver(Class<? extends WebDriver> driverClass) {
        return RemoteWebDriver.class == driverClass;
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAChromeDriver(Class<? extends WebDriver> driverClass) {
        return ChromeDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isASafariDriver(Class<? extends WebDriver> driverClass) {
        return SafariDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnInternetExplorerDriver(Class<? extends WebDriver> driverClass) {
        return InternetExplorerDriver.class.isAssignableFrom(driverClass);
    }

    private boolean usesFirefox(WebDriver driver) {
        return FirefoxDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesInternetExplorer(WebDriver driver) {
        return InternetExplorerDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private boolean usesChrome(WebDriver driver) {
        return ChromeDriver.class.isAssignableFrom(this.getDriverClass(driver));
    }

    private Class getDriverClass(WebDriver driver) {
        Class<Object> driverClass = null;
        driverClass = driver instanceof WebDriverFacade ? ((WebDriverFacade)driver).getDriverClass() : driver.getClass();
        return driverClass;
    }

    private boolean isAnHtmlUnitDriver(Class<? extends WebDriver> driverClass) {
        return HtmlUnitDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAPhantomJSDriver(Class<? extends WebDriver> driverClass) {
        return PhantomJSDriver.class.isAssignableFrom(driverClass);
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile;
        if (Thucydides.getFirefoxProfile() != null) {
            profile = Thucydides.getFirefoxProfile();
        } else {
            profile = new FirefoxProfile();
            profile.setPreference("network.proxy.socks_port", 9999);
            profile.setAlwaysLoadNoFocusLib(true);
            profile.setEnableNativeEvents(true);
        }
        return profile;
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    protected FirefoxProfile buildFirefoxProfile() {
        String profileName = this.environmentVariables.getProperty("webdriver.firefox.profile");
        DesiredCapabilities firefoxCapabilities = DesiredCapabilities.firefox();
        if (StringUtils.isNotEmpty((CharSequence)profileName)) {
            firefoxCapabilities.setCapability("firefox_profile", profileName);
        }
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
        this.firefoxProfileEnhancer.activateNativeEventsFor(profile, this.shouldEnableNativeEvents());
        if (this.shouldActivateProxy()) {
            this.activateProxyFor(profile, this.firefoxProfileEnhancer);
        }
        if (this.firefoxProfileEnhancer.shouldActivateFirebugs()) {
            this.firefoxProfileEnhancer.addFirebugsTo(profile);
        }
        if (this.refuseUntrustedCertificates()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
            profile.setAcceptUntrustedCertificates(false);
        } else {
            profile.setAssumeUntrustedCertificateIssuer(true);
            profile.setAcceptUntrustedCertificates(true);
        }
        this.firefoxProfileEnhancer.configureJavaSupport(profile);
        this.firefoxProfileEnhancer.addPreferences(profile);
        return profile;
    }

    private boolean shouldEnableNativeEvents() {
        return Boolean.valueOf(ThucydidesSystemProperty.NATIVE_EVENTS.from(this.environmentVariables, "true"));
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_PORT.getPropertyName());
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.PROXY_URL.getPropertyName());
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private boolean refuseUntrustedCertificates() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.getPropertyName(), false);
    }

    public void initElementsWithAjaxSupport(PageObject pageObject, WebDriver driver, int timeoutInSeconds) {
        this.proxyCreator.proxyElements(pageObject, driver, timeoutInSeconds);
    }
}

